/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.feed;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import org.instancio.feed.Feed;
import org.instancio.feed.FeedSpec;
import org.instancio.feed.FeedSpecAnnotations;
import org.instancio.internal.util.ErrorMessageUtils;
import org.instancio.internal.util.Fail;
import org.instancio.internal.util.TypeUtils;

public final class SpecMethod {
    private final Method method;
    private final Class<?> targetType;
    private final FeedSpecAnnotations.GeneratedSpec generatedSpec;
    private final FeedSpecAnnotations.FunctionSpec functionSpec;
    private final FeedSpecAnnotations.TemplateSpec templateSpec;
    private final String dataPropertyName;

    public SpecMethod(Method method) {
        this.method = method;
        this.targetType = this.resolveTargetType();
        this.generatedSpec = this.getAnnotation(FeedSpecAnnotations.GeneratedSpec.class);
        this.functionSpec = this.getAnnotation(FeedSpecAnnotations.FunctionSpec.class);
        this.templateSpec = this.getAnnotation(FeedSpecAnnotations.TemplateSpec.class);
        FeedSpecAnnotations.DataSpec dataSpec = this.getAnnotation(FeedSpecAnnotations.DataSpec.class);
        this.dataPropertyName = dataSpec == null ? method.getName() : dataSpec.value();
    }

    public Method getMethod() {
        return this.method;
    }

    public FeedSpecAnnotations.GeneratedSpec getGeneratedSpec() {
        return this.generatedSpec;
    }

    public FeedSpecAnnotations.FunctionSpec getFunctionSpec() {
        return this.functionSpec;
    }

    public FeedSpecAnnotations.TemplateSpec getTemplateSpec() {
        return this.templateSpec;
    }

    public String getDataPropertyName() {
        return this.dataPropertyName;
    }

    public <T> Class<T> getTargetType() {
        return this.targetType;
    }

    public boolean hasNullableAnnotation() {
        return this.method.getDeclaredAnnotation(FeedSpecAnnotations.NullableSpec.class) != null;
    }

    public <A extends Annotation> A getAnnotation(Class<A> annotationClass) {
        return this.method.getDeclaredAnnotation(annotationClass);
    }

    public boolean isDeclaredByFeedInterface() {
        Class<?> superclass = Feed.class.getInterfaces()[0];
        return this.method.getDeclaringClass() == superclass;
    }

    private Class<?> resolveTargetType() {
        if (this.isDeclaredByFeedInterface()) {
            return TypeUtils.getFirstTypeArg(this.method.getGenericReturnType());
        }
        Type returnType = this.method.getGenericReturnType();
        Class rawType = TypeUtils.getRawType(returnType);
        if (rawType == FeedSpec.class) {
            Type[] typeArgs = ((ParameterizedType)returnType).getActualTypeArguments();
            return TypeUtils.getRawType(typeArgs[0]);
        }
        throw Fail.withUsageError(ErrorMessageUtils.invalidSpecMethod(this.method), new Object[0]);
    }
}

