/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.feed;

import java.io.InputStream;
import java.nio.file.Path;
import org.instancio.FeedApi;
import org.instancio.documentation.ExperimentalApi;
import org.instancio.feed.Feed;
import org.instancio.internal.feed.InternalFeedContext;

@ExperimentalApi
@FunctionalInterface
public interface FeedProvider {
    @ExperimentalApi
    public FeedApi get(FeedBuilderFactory var1);

    @ExperimentalApi
    public static interface FeedBuilderFactory {
        @ExperimentalApi
        default public <F extends Feed> FeedApi of(Class<F> feedClass) {
            return InternalFeedContext.builder(feedClass);
        }

        @ExperimentalApi
        default public FeedApi ofInputStream(InputStream inputStream) {
            return InternalFeedContext.builder(source -> source.ofInputStream(inputStream));
        }

        @ExperimentalApi
        default public FeedApi ofFile(Path path) {
            return InternalFeedContext.builder(source -> source.ofFile(path));
        }

        @ExperimentalApi
        default public FeedApi ofResource(String name) {
            return InternalFeedContext.builder(source -> source.ofResource(name));
        }

        @ExperimentalApi
        default public FeedApi ofString(String data) {
            return InternalFeedContext.builder(source -> source.ofString(data));
        }
    }
}

