/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.settings;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.instancio.documentation.ExperimentalApi;
import org.instancio.generator.AfterGenerate;
import org.instancio.internal.settings.InternalKey;
import org.instancio.internal.settings.RangeAdjuster;
import org.instancio.settings.AssignmentType;
import org.instancio.settings.BeanValidationTarget;
import org.instancio.settings.FeedDataAccess;
import org.instancio.settings.FeedDataEndAction;
import org.instancio.settings.FeedDataTrim;
import org.instancio.settings.FeedFormatType;
import org.instancio.settings.Mode;
import org.instancio.settings.OnSetFieldError;
import org.instancio.settings.OnSetMethodError;
import org.instancio.settings.OnSetMethodNotFound;
import org.instancio.settings.OnSetMethodUnmatched;
import org.instancio.settings.SetterStyle;
import org.instancio.settings.SettingKey;
import org.instancio.settings.StringCase;
import org.instancio.settings.StringType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Keys {
    private static final RangeAdjuster MIN_ADJUSTER = RangeAdjuster.MIN_ADJUSTER;
    private static final RangeAdjuster MAX_ADJUSTER = RangeAdjuster.MAX_ADJUSTER;
    private static final List<SettingKey<Object>> ALL_KEYS = new ArrayList<SettingKey<Object>>();
    @ExperimentalApi
    public static final SettingKey<AssignmentType> ASSIGNMENT_TYPE = Keys.registerRequiredNonAdjustable("assignment.type", AssignmentType.class, (Object)AssignmentType.FIELD);
    public static final SettingKey<AfterGenerate> AFTER_GENERATE_HINT = Keys.registerRequiredNonAdjustable("hint.after.generate", AfterGenerate.class, (Object)AfterGenerate.POPULATE_NULLS_AND_DEFAULT_PRIMITIVES);
    public static final SettingKey<Boolean> ARRAY_ELEMENTS_NULLABLE = Keys.registerRequiredNonAdjustable("array.elements.nullable", Boolean.class, false);
    public static final SettingKey<Integer> ARRAY_MIN_LENGTH = Keys.registerRequiredAdjustable("array.min.length", Integer.class, 2, MIN_ADJUSTER, false);
    public static final SettingKey<Integer> ARRAY_MAX_LENGTH = Keys.registerRequiredAdjustable("array.max.length", Integer.class, 6, MAX_ADJUSTER, false);
    public static final SettingKey<Boolean> ARRAY_NULLABLE = Keys.registerRequiredNonAdjustable("array.nullable", Boolean.class, false);
    @ExperimentalApi
    public static final SettingKey<Boolean> BEAN_VALIDATION_ENABLED = Keys.registerRequiredNonAdjustable("bean.validation.enabled", Boolean.class, false);
    @ExperimentalApi
    public static final SettingKey<BeanValidationTarget> BEAN_VALIDATION_TARGET = Keys.registerRequiredNonAdjustable("bean.validation.target", BeanValidationTarget.class, (Object)BeanValidationTarget.FIELD);
    @ExperimentalApi
    public static final SettingKey<Integer> BIG_DECIMAL_SCALE = Keys.registerRequiredNonAdjustable("bigdecimal.scale", Integer.class, 2);
    public static final SettingKey<Boolean> BOOLEAN_NULLABLE = Keys.registerRequiredNonAdjustable("boolean.nullable", Boolean.class, false);
    public static final SettingKey<Byte> BYTE_MIN = Keys.registerRequiredAdjustable("byte.min", Byte.class, (byte)1, MIN_ADJUSTER, true);
    public static final SettingKey<Byte> BYTE_MAX = Keys.registerRequiredAdjustable("byte.max", Byte.class, (byte)127, MAX_ADJUSTER, true);
    public static final SettingKey<Boolean> BYTE_NULLABLE = Keys.registerRequiredNonAdjustable("byte.nullable", Boolean.class, false);
    public static final SettingKey<Boolean> CHARACTER_NULLABLE = Keys.registerRequiredNonAdjustable("character.nullable", Boolean.class, false);
    public static final SettingKey<Boolean> COLLECTION_ELEMENTS_NULLABLE = Keys.registerRequiredNonAdjustable("collection.elements.nullable", Boolean.class, false);
    public static final SettingKey<Integer> COLLECTION_MIN_SIZE = Keys.registerRequiredAdjustable("collection.min.size", Integer.class, 2, MIN_ADJUSTER, false);
    public static final SettingKey<Integer> COLLECTION_MAX_SIZE = Keys.registerRequiredAdjustable("collection.max.size", Integer.class, 6, MAX_ADJUSTER, false);
    public static final SettingKey<Boolean> COLLECTION_NULLABLE = Keys.registerRequiredNonAdjustable("collection.nullable", Boolean.class, false);
    public static final SettingKey<Double> DOUBLE_MIN = Keys.registerRequiredAdjustable("double.min", Double.class, 1.0, MIN_ADJUSTER, true);
    public static final SettingKey<Double> DOUBLE_MAX = Keys.registerRequiredAdjustable("double.max", Double.class, 10000.0, MAX_ADJUSTER, true);
    public static final SettingKey<Boolean> DOUBLE_NULLABLE = Keys.registerRequiredNonAdjustable("double.nullable", Boolean.class, false);
    @ExperimentalApi
    public static final SettingKey<Boolean> FAIL_ON_ERROR = Keys.registerRequiredNonAdjustable("fail.on.error", Boolean.class, false);
    public static final SettingKey<Float> FLOAT_MIN = Keys.registerRequiredAdjustable("float.min", Float.class, Float.valueOf(1.0f), MIN_ADJUSTER, true);
    public static final SettingKey<Float> FLOAT_MAX = Keys.registerRequiredAdjustable("float.max", Float.class, Float.valueOf(10000.0f), MAX_ADJUSTER, true);
    public static final SettingKey<Boolean> FLOAT_NULLABLE = Keys.registerRequiredNonAdjustable("float.nullable", Boolean.class, false);
    @ExperimentalApi
    public static final SettingKey<Integer> INSTANCIO_SOURCE_SAMPLES = Keys.registerRequiredNonAdjustable("instancio.source.samples", Integer.class, 100);
    public static final SettingKey<Integer> INTEGER_MIN = Keys.registerRequiredAdjustable("integer.min", Integer.class, 1, MIN_ADJUSTER, true);
    public static final SettingKey<Integer> INTEGER_MAX = Keys.registerRequiredAdjustable("integer.max", Integer.class, 10000, MAX_ADJUSTER, true);
    public static final SettingKey<Boolean> INTEGER_NULLABLE = Keys.registerRequiredNonAdjustable("integer.nullable", Boolean.class, false);
    @ExperimentalApi
    public static final SettingKey<Boolean> JPA_ENABLED = Keys.registerRequiredNonAdjustable("jpa.enabled", Boolean.class, false);
    public static final SettingKey<Long> LONG_MIN = Keys.registerRequiredAdjustable("long.min", Long.class, 1L, MIN_ADJUSTER, true);
    public static final SettingKey<Long> LONG_MAX = Keys.registerRequiredAdjustable("long.max", Long.class, 10000L, MAX_ADJUSTER, true);
    public static final SettingKey<Boolean> LONG_NULLABLE = Keys.registerRequiredNonAdjustable("long.nullable", Boolean.class, false);
    public static final SettingKey<Boolean> MAP_KEYS_NULLABLE = Keys.registerRequiredNonAdjustable("map.keys.nullable", Boolean.class, false);
    public static final SettingKey<Integer> MAP_MIN_SIZE = Keys.registerRequiredAdjustable("map.min.size", Integer.class, 2, MIN_ADJUSTER, false);
    public static final SettingKey<Integer> MAP_MAX_SIZE = Keys.registerRequiredAdjustable("map.max.size", Integer.class, 6, MAX_ADJUSTER, false);
    public static final SettingKey<Boolean> MAP_NULLABLE = Keys.registerRequiredNonAdjustable("map.nullable", Boolean.class, false);
    public static final SettingKey<Boolean> MAP_VALUES_NULLABLE = Keys.registerRequiredNonAdjustable("map.values.nullable", Boolean.class, false);
    public static final SettingKey<Integer> MAX_DEPTH = Keys.registerRequiredNonAdjustable("max.depth", Integer.class, 8);
    @ExperimentalApi
    public static final SettingKey<Integer> MAX_GENERATION_ATTEMPTS = Keys.registerRequiredNonAdjustable("max.generation.attempts", Integer.class, 1000);
    public static final SettingKey<Mode> MODE = Keys.registerRequiredNonAdjustable("mode", Mode.class, (Object)Mode.STRICT);
    @ExperimentalApi
    public static final SettingKey<OnSetFieldError> ON_SET_FIELD_ERROR = Keys.registerRequiredNonAdjustable("on.set.field.error", OnSetFieldError.class, (Object)OnSetFieldError.IGNORE);
    @ExperimentalApi
    public static final SettingKey<OnSetMethodError> ON_SET_METHOD_ERROR = Keys.registerRequiredNonAdjustable("on.set.method.error", OnSetMethodError.class, (Object)OnSetMethodError.ASSIGN_FIELD);
    @ExperimentalApi
    public static final SettingKey<OnSetMethodNotFound> ON_SET_METHOD_NOT_FOUND = Keys.registerRequiredNonAdjustable("on.set.method.not.found", OnSetMethodNotFound.class, (Object)OnSetMethodNotFound.ASSIGN_FIELD);
    @ExperimentalApi
    public static final SettingKey<OnSetMethodUnmatched> ON_SET_METHOD_UNMATCHED = Keys.registerRequiredNonAdjustable("on.set.method.unmatched", OnSetMethodUnmatched.class, (Object)OnSetMethodUnmatched.IGNORE);
    public static final SettingKey<Boolean> OVERWRITE_EXISTING_VALUES = Keys.registerRequiredNonAdjustable("overwrite.existing.values", Boolean.class, true);
    @ExperimentalApi
    public static final SettingKey<FeedDataAccess> FEED_DATA_ACCESS = Keys.registerRequiredNonAdjustable("feed.data.access", FeedDataAccess.class, (Object)FeedDataAccess.SEQUENTIAL);
    @ExperimentalApi
    public static final SettingKey<FeedDataEndAction> FEED_DATA_END_ACTION = Keys.registerRequiredNonAdjustable("feed.data.end.action", FeedDataEndAction.class, (Object)FeedDataEndAction.FAIL);
    @ExperimentalApi
    public static final SettingKey<FeedDataTrim> FEED_DATA_TRIM = Keys.registerRequiredNonAdjustable("feed.data.trim", FeedDataTrim.class, (Object)FeedDataTrim.UNQUOTED);
    @ExperimentalApi
    public static final SettingKey<FeedFormatType> FEED_FORMAT_TYPE = Keys.registerRequiredNonAdjustable("feed.format.type", FeedFormatType.class, (Object)FeedFormatType.CSV);
    @ExperimentalApi
    public static final SettingKey<String> FEED_TAG_KEY = Keys.register("feed.tag.key", String.class, null, null, true, false);
    @ExperimentalApi
    public static final SettingKey<String> FEED_TAG_VALUE = Keys.register("feed.tag.value", String.class, null, null, true, false);
    public static final SettingKey<Long> SEED = Keys.register("seed", Long.class, null, null, true, true);
    @ExperimentalApi
    public static final SettingKey<Boolean> SET_BACK_REFERENCES = Keys.registerRequiredNonAdjustable("set.back.references", Boolean.class, false);
    @ExperimentalApi
    public static final SettingKey<Integer> SETTER_EXCLUDE_MODIFIER = Keys.registerRequiredNonAdjustable("setter.exclude.modifier", Integer.class, 0);
    @ExperimentalApi
    public static final SettingKey<SetterStyle> SETTER_STYLE = Keys.registerRequiredNonAdjustable("setter.style", SetterStyle.class, (Object)SetterStyle.SET);
    public static final SettingKey<Short> SHORT_MIN = Keys.registerRequiredAdjustable("short.min", Short.class, (short)1, MIN_ADJUSTER, true);
    public static final SettingKey<Short> SHORT_MAX = Keys.registerRequiredAdjustable("short.max", Short.class, (short)10000, MAX_ADJUSTER, true);
    public static final SettingKey<Boolean> SHORT_NULLABLE = Keys.registerRequiredNonAdjustable("short.nullable", Boolean.class, false);
    public static final SettingKey<Boolean> STRING_ALLOW_EMPTY = Keys.registerRequiredNonAdjustable("string.allow.empty", Boolean.class, false);
    public static final SettingKey<Boolean> STRING_FIELD_PREFIX_ENABLED = Keys.registerRequiredNonAdjustable("string.field.prefix.enabled", Boolean.class, false);
    public static final SettingKey<Integer> STRING_MIN_LENGTH = Keys.registerRequiredAdjustable("string.min.length", Integer.class, 3, MIN_ADJUSTER, false);
    public static final SettingKey<Integer> STRING_MAX_LENGTH = Keys.registerRequiredAdjustable("string.max.length", Integer.class, 10, MAX_ADJUSTER, false);
    public static final SettingKey<Boolean> STRING_NULLABLE = Keys.registerRequiredNonAdjustable("string.nullable", Boolean.class, false);
    @ExperimentalApi
    public static final SettingKey<StringCase> STRING_CASE = Keys.registerRequiredNonAdjustable("string.case", StringCase.class, (Object)StringCase.UPPER);
    @ExperimentalApi
    public static final SettingKey<StringType> STRING_TYPE = Keys.registerRequiredNonAdjustable("string.type", StringType.class, (Object)StringType.ALPHABETIC);
    private static final Map<String, SettingKey<?>> SETTING_KEY_MAP = Collections.unmodifiableMap(Keys.settingKeyMap());

    private static Map<String, SettingKey<?>> settingKeyMap() {
        HashMap map = new HashMap();
        for (SettingKey<Object> key : ALL_KEYS) {
            map.put(key.propertyKey(), key);
        }
        return map;
    }

    public static List<SettingKey<Object>> all() {
        return Collections.unmodifiableList(ALL_KEYS);
    }

    public static <T> SettingKey<T> get(@NotNull String key) {
        return SETTING_KEY_MAP.get(key);
    }

    @ExperimentalApi
    public static <T> SettingKey.SettingKeyBuilder<T> ofType(Class<T> type) {
        return InternalKey.builder(type);
    }

    private static <T> SettingKey<T> register(@NotNull String propertyKey, @NotNull Class<T> type, @Nullable Object defaultValue, @Nullable RangeAdjuster rangeAdjuster, boolean allowsNullValue, boolean allowsNegative) {
        InternalKey settingKey = new InternalKey(propertyKey, type, defaultValue, rangeAdjuster, allowsNullValue, allowsNegative);
        ALL_KEYS.add(settingKey);
        return settingKey;
    }

    private static <T> SettingKey<T> registerRequiredAdjustable(@NotNull String propertyKey, @NotNull Class<T> type, @Nullable Object defaultValue, @Nullable RangeAdjuster rangeAdjuster, boolean allowsNegative) {
        return Keys.register(propertyKey, type, defaultValue, rangeAdjuster, false, allowsNegative);
    }

    private static <T> SettingKey<T> registerRequiredNonAdjustable(@NotNull String key, @NotNull Class<T> type, @NotNull Object defaultValue) {
        return Keys.register(key, type, defaultValue, null, false, false);
    }

    private Keys() {
    }
}

