/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.generator.text;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import org.instancio.Random;
import org.instancio.generator.GeneratorContext;
import org.instancio.generator.specs.WordSpec;
import org.instancio.internal.generator.AbstractGenerator;
import org.instancio.internal.util.Fail;
import org.instancio.internal.util.ObjectUtils;

public class WordGenerator
extends AbstractGenerator<String>
implements WordSpec {
    private static final Map<WordClass, List<String>> CACHE = new EnumMap<WordClass, List<String>>(WordClass.class);
    private WordClass wordClass;

    public WordGenerator(GeneratorContext context) {
        super(context);
    }

    @Override
    public String apiMethod() {
        return "word()";
    }

    @Override
    public WordGenerator adjective() {
        this.wordClass = WordClass.ADJECTIVE;
        return this;
    }

    @Override
    public WordGenerator adverb() {
        this.wordClass = WordClass.ADVERB;
        return this;
    }

    @Override
    public WordGenerator noun() {
        this.wordClass = WordClass.NOUN;
        return this;
    }

    @Override
    public WordGenerator verb() {
        this.wordClass = WordClass.VERB;
        return this;
    }

    @Override
    public WordGenerator nullable() {
        super.nullable();
        return this;
    }

    @Override
    protected String tryGenerateNonNull(Random random) {
        WordClass wc = ObjectUtils.defaultIfNull(this.wordClass, () -> random.oneOf(WordClass.values()));
        return this.getWord(random, wc);
    }

    private String getWord(Random random, WordClass wordClass) {
        List<String> words = this.getWords(wordClass);
        return random.oneOf(words);
    }

    private List<String> getWords(WordClass wordClass) {
        List<String> words = CACHE.get((Object)wordClass);
        if (words == null) {
            words = WordGenerator.load(wordClass.file);
            CACHE.put(wordClass, words);
        }
        return words;
    }

    private static List<String> load(String file) {
        ArrayList<String> results = new ArrayList<String>(3000);
        try {
            InputStream in = WordGenerator.class.getResourceAsStream(file);
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(in));){
                String line;
                while ((line = reader.readLine()) != null) {
                    results.add(line);
                }
            }
        }
        catch (Exception ex) {
            throw Fail.withInternalError("Error loading input stream", ex);
        }
        return results;
    }

    private static enum WordClass {
        ADJECTIVE("/adjectives.txt"),
        ADVERB("/adverbs.txt"),
        NOUN("/nouns.txt"),
        VERB("/verbs.txt");

        private final String file;

        private WordClass(String file) {
            this.file = file;
        }
    }
}

