/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.generation;

import org.instancio.generator.AfterGenerate;
import org.instancio.generator.Hints;
import org.instancio.internal.context.ModelContext;
import org.instancio.internal.generation.NodeHandler;
import org.instancio.internal.generator.GeneratorResult;
import org.instancio.internal.instantiation.Instantiator;
import org.instancio.internal.nodes.InternalNode;
import org.instancio.internal.nodes.NodeKind;
import org.instancio.internal.util.ReflectionUtils;
import org.jetbrains.annotations.NotNull;

class InstantiatingHandler
implements NodeHandler {
    private static final Hints POPULATE_ALL_HINT = Hints.builder().afterGenerate(AfterGenerate.POPULATE_ALL).build();
    private final Instantiator instantiator;

    InstantiatingHandler(ModelContext<?> context) {
        this.instantiator = new Instantiator(context.getServiceProviders().getTypeInstantiators());
    }

    @Override
    @NotNull
    public GeneratorResult getResult(@NotNull InternalNode node) {
        if (node.is(NodeKind.RECORD) && !node.getChildren().isEmpty()) {
            return GeneratorResult.emptyResult();
        }
        Class<?> targetClass = node.getTargetClass();
        if (ReflectionUtils.isArrayOrConcrete(targetClass)) {
            Object object = this.instantiator.instantiate(targetClass);
            return GeneratorResult.create(object, POPULATE_ALL_HINT);
        }
        return GeneratorResult.emptyResult();
    }
}

