/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.generation;

import java.util.IdentityHashMap;
import java.util.Map;
import org.instancio.internal.context.ModelContext;
import org.instancio.internal.generator.GeneratorResult;
import org.instancio.internal.nodes.InternalNode;
import org.instancio.internal.nodes.NodeKind;
import org.instancio.internal.util.Constants;
import org.instancio.internal.util.Verify;
import org.instancio.settings.Keys;

class GeneratedPojoStore {
    private final Map<InternalNode, Object> generatedPojos = new IdentityHashMap<InternalNode, Object>();

    private GeneratedPojoStore() {
    }

    static GeneratedPojoStore createStore(ModelContext<?> context) {
        boolean backRefsEnabled = context.getSettings().get(Keys.SET_BACK_REFERENCES);
        return backRefsEnabled ? new GeneratedPojoStore() : new NoopGeneratedPojoStore();
    }

    GeneratorResult getParentObject(InternalNode node) {
        Verify.isTrue(node.isCyclic(), "Non-cyclic node: %s", node);
        Class<?> targetClass = node.getTargetClass();
        for (InternalNode n = node.getParent(); n != null; n = n.getParent()) {
            Object o;
            if (n.getTargetClass() != targetClass || (o = this.generatedPojos.get(n)) == null) continue;
            return GeneratorResult.create(o, Constants.DO_NOT_MODIFY_HINT);
        }
        return GeneratorResult.emptyResult();
    }

    void putValue(InternalNode node, GeneratorResult result) {
        if (node.is(NodeKind.POJO) && !result.containsNull()) {
            this.generatedPojos.put(node, result.getValue());
        }
    }

    private static final class NoopGeneratedPojoStore
    extends GeneratedPojoStore {
        private NoopGeneratedPojoStore() {
        }

        @Override
        GeneratorResult getParentObject(InternalNode node) {
            return GeneratorResult.emptyResult();
        }

        @Override
        void putValue(InternalNode node, GeneratorResult result) {
        }
    }
}

