/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.generation;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.instancio.exception.InstancioException;
import org.instancio.exception.InstancioTerminatingException;
import org.instancio.generator.Generator;
import org.instancio.generator.GeneratorContext;
import org.instancio.internal.PrimitiveWrapperBiLookup;
import org.instancio.internal.annotation.AnnotationConsumer;
import org.instancio.internal.annotation.AnnotationConsumers;
import org.instancio.internal.annotation.AnnotationExtractor;
import org.instancio.internal.annotation.AnnotationMap;
import org.instancio.internal.context.ModelContext;
import org.instancio.internal.generation.GeneratedValuePostProcessor;
import org.instancio.internal.generation.NodeHandler;
import org.instancio.internal.generation.StringPrefixingPostProcessor;
import org.instancio.internal.generator.GeneratorResolver;
import org.instancio.internal.generator.GeneratorResult;
import org.instancio.internal.nodes.InternalNode;
import org.instancio.internal.spi.ProviderEntry;
import org.instancio.internal.util.ErrorMessageUtils;
import org.instancio.internal.util.Fail;
import org.instancio.internal.util.ReflectionUtils;
import org.instancio.settings.Keys;
import org.instancio.spi.InstancioServiceProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class AnnotationNodeHandler
implements NodeHandler {
    private final List<AnnotationConsumer> annotationConsumers;
    private final AnnotationExtractor annotationExtractor;
    private final ModelContext<?> modelContext;
    private final GeneratorContext generatorContext;
    private final GeneratorResolver generatorResolver;
    private final GeneratedValuePostProcessor stringPostProcessor;
    private final Map<Class<?>, List<AnnotatedMethod>> annotatedMethodsMap;
    private final boolean beanValidationOrJpaEnabled;

    private AnnotationNodeHandler(ModelContext<?> modelContext, GeneratorResolver generatorResolver, List<ProviderEntry<InstancioServiceProvider.AnnotationProcessor>> annotationProcessors, boolean beanValidationOrJpaEnabled) {
        this.modelContext = modelContext;
        this.generatorResolver = generatorResolver;
        this.annotationConsumers = AnnotationConsumers.get(modelContext);
        this.annotationExtractor = new AnnotationExtractor(modelContext);
        this.stringPostProcessor = new StringPrefixingPostProcessor(modelContext.getSettings().get(Keys.STRING_FIELD_PREFIX_ENABLED));
        this.generatorContext = new GeneratorContext(modelContext.getSettings(), modelContext.getRandom());
        this.annotatedMethodsMap = AnnotationNodeHandler.collectAnnotatedMethods(annotationProcessors);
        this.beanValidationOrJpaEnabled = beanValidationOrJpaEnabled;
    }

    static NodeHandler create(ModelContext<?> context, GeneratorResolver generatorResolver) {
        boolean bvOrJpaEnabled = context.getSettings().get(Keys.BEAN_VALIDATION_ENABLED) != false || context.getSettings().get(Keys.JPA_ENABLED) != false;
        List<ProviderEntry<InstancioServiceProvider.AnnotationProcessor>> annotationProcessors = context.getServiceProviders().getAnnotationProcessors();
        return bvOrJpaEnabled || !annotationProcessors.isEmpty() ? new AnnotationNodeHandler(context, generatorResolver, annotationProcessors, bvOrJpaEnabled) : NOOP_HANDLER;
    }

    private static Map<Class<?>, List<AnnotatedMethod>> collectAnnotatedMethods(List<ProviderEntry<InstancioServiceProvider.AnnotationProcessor>> annotationProcessors) {
        if (annotationProcessors.isEmpty()) {
            return Collections.emptyMap();
        }
        LinkedHashMap<Class, List> results = new LinkedHashMap<Class, List>();
        for (ProviderEntry<InstancioServiceProvider.AnnotationProcessor> entry : annotationProcessors) {
            InstancioServiceProvider.AnnotationProcessor processor = entry.getProvider();
            for (Method method : processor.getClass().getDeclaredMethods()) {
                ReflectionUtils.setAccessible(method);
                if (method.getDeclaredAnnotation(InstancioServiceProvider.AnnotationProcessor.AnnotationHandler.class) == null) continue;
                Class<?>[] paramTypes = method.getParameterTypes();
                AnnotatedMethod annotatedMethod = new AnnotatedMethod(processor, method);
                if (paramTypes.length <= 0) continue;
                Class<?> annotationType = paramTypes[0];
                results.computeIfAbsent(annotationType, v -> new ArrayList()).add(annotatedMethod);
            }
        }
        return Collections.unmodifiableMap(results);
    }

    @Override
    @NotNull
    public GeneratorResult getResult(@NotNull InternalNode node) {
        Generator<?> generator;
        Annotation[] annotations = this.annotationExtractor.getAnnotations(node);
        if (annotations.length == 0) {
            return GeneratorResult.emptyResult();
        }
        if (this.beanValidationOrJpaEnabled) {
            AnnotationMap annotationMap = new AnnotationMap(annotations);
            generator = this.getGenerator(node, annotations, annotationMap);
            for (AnnotationConsumer provider : this.annotationConsumers) {
                provider.consumeAnnotations(annotationMap, generator, node.getTargetClass());
            }
        } else {
            generator = this.generatorResolver.get(node);
        }
        if (generator == null) {
            return GeneratorResult.emptyResult();
        }
        this.invokeAnnotationHandlerMethods(node, annotations, generator);
        Object obj = generator.generate(this.modelContext.getRandom());
        if (node.getTargetClass() == String.class) {
            obj = obj.toString();
        } else if (!AnnotationNodeHandler.isObjectAssignableToNode(node, obj)) {
            Generator<?> builtInGenerator = this.generatorResolver.get(node);
            obj = builtInGenerator.generate(this.modelContext.getRandom());
        }
        Object processed = this.stringPostProcessor.process(obj, node, generator);
        return GeneratorResult.create(processed, generator.hints());
    }

    private void invokeAnnotationHandlerMethods(InternalNode node, Annotation[] annotations, Generator<?> generator) {
        for (Annotation annotation : annotations) {
            List annotatedMethods = this.annotatedMethodsMap.getOrDefault(annotation.annotationType(), Collections.emptyList());
            for (AnnotatedMethod method : annotatedMethods) {
                method.invoke(annotation, generator, node);
            }
        }
    }

    private static boolean isObjectAssignableToNode(InternalNode node, Object obj) {
        if (obj == null) {
            return true;
        }
        Class<?> targetClass = node.getTargetClass();
        if (targetClass.isPrimitive()) {
            targetClass = PrimitiveWrapperBiLookup.getEquivalent(targetClass);
        }
        return targetClass.isAssignableFrom(obj.getClass());
    }

    @Nullable
    private Generator<?> getGenerator(InternalNode node, Annotation[] annotations, AnnotationMap annotationMap) {
        for (AnnotationConsumer provider : this.annotationConsumers) {
            for (Annotation annotation : annotations) {
                if (!provider.isPrimary(annotation.annotationType())) continue;
                annotationMap.setPrimary(annotation);
                return provider.resolveGenerator(annotation, this.generatorContext);
            }
        }
        return this.generatorResolver.get(node);
    }

    private static final class AnnotatedMethod {
        private final InstancioServiceProvider.AnnotationProcessor processor;
        private final Method method;
        private final Class<?>[] params;

        AnnotatedMethod(InstancioServiceProvider.AnnotationProcessor processor, Method method) {
            this.processor = processor;
            this.method = method;
            this.params = method.getParameterTypes();
        }

        void invoke(Annotation annotation, Generator<?> generator, InternalNode node) {
            block6: {
                try {
                    if (this.params.length == 2) {
                        this.method.invoke((Object)this.processor, annotation, generator);
                        break block6;
                    }
                    if (this.params.length == 3) {
                        this.method.invoke((Object)this.processor, annotation, generator, node);
                        break block6;
                    }
                    throw Fail.withUsageError(ErrorMessageUtils.annotationHandlerInvalidNumberOfParameters(this.processor.getClass(), this.method), new Object[0]);
                }
                catch (IllegalArgumentException ex) {
                    String msg = ErrorMessageUtils.invalidAnnotationHandlerMethod(this.processor.getClass(), this.method, annotation, generator, node);
                    throw Fail.withUsageError(msg, ex);
                }
                catch (AssertionError | InstancioTerminatingException ex) {
                    throw ex;
                }
                catch (Exception ex) {
                    throw new InstancioException("Failed invoking @AnnotationHandler method", ex);
                }
            }
        }
    }
}

