/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.feed;

import java.lang.reflect.Method;
import org.instancio.feed.Feed;
import org.instancio.feed.FeedSpec;
import org.instancio.internal.feed.InternalFeed;
import org.instancio.internal.feed.InternalFeedProxy;
import org.instancio.internal.feed.SpecMethod;
import org.instancio.internal.nodes.InternalNode;
import org.instancio.internal.util.ReflectionUtils;
import org.jetbrains.annotations.Nullable;

public class InternalFeedSpecResolver {
    private final InternalFeed feed;

    public InternalFeedSpecResolver(Feed feed) {
        this.feed = InternalFeedProxy.asInternalFeed(feed);
    }

    @Nullable
    public FeedSpec<?> getSpec(InternalNode node) {
        String nodeFieldName;
        Class<?> feedClass = this.feed.getFeedContext().getFeedClass();
        Method matchingSpec = ReflectionUtils.getZeroArgMethod(feedClass, nodeFieldName = node.getField().getName());
        if (matchingSpec != null) {
            return this.feed.createSpec(new SpecMethod(matchingSpec), null);
        }
        return this.feed.getDataProperties().contains(nodeFieldName) ? this.feed.createSpec(nodeFieldName, node.getTargetClass()) : null;
    }
}

