/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal;

import java.lang.reflect.Type;
import org.instancio.internal.PrimitiveWrapperBiLookup;
import org.instancio.internal.context.ModelContext;
import org.instancio.internal.generation.GenerationListener;
import org.instancio.internal.generator.GeneratorResult;
import org.instancio.internal.nodes.InternalNode;
import org.instancio.internal.util.Fail;
import org.instancio.internal.util.Format;
import org.instancio.internal.util.TypeUtils;

final class SetModelValidatingListener
implements GenerationListener {
    private final ModelContext<?> context;

    private SetModelValidatingListener(ModelContext<?> context) {
        this.context = context;
    }

    static GenerationListener create(ModelContext<?> context) {
        return context.getSelectorMaps().hasSetModels() ? new SetModelValidatingListener(context) : NOOP_LISTENER;
    }

    @Override
    public void objectCreated(InternalNode node, GeneratorResult result) {
        Class<?> targetClass;
        ModelContext<?> otherContext = this.context.getSetModelSelectorMap().getContext(node);
        if (otherContext == null) {
            return;
        }
        Type modelRootType = otherContext.getRootType();
        Class modelRawType = TypeUtils.getRawType(modelRootType);
        Class<?> clazz = targetClass = node.getTargetClass().isPrimitive() ? PrimitiveWrapperBiLookup.getEquivalent(node.getTargetClass()) : node.getTargetClass();
        if (!modelRawType.isAssignableFrom(targetClass)) {
            String modelTypeName = Format.withoutPackage(modelRootType);
            throw Fail.withUsageError("Model<%s> specified in setModel() method is incompatible with the selector target%n%n -> Model type ............: %s%n -> Selector target type ..: %s", modelTypeName, modelTypeName, Format.withoutPackage(node.getType()));
        }
    }
}

