/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal;

import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.instancio.internal.util.Constants;
import org.instancio.internal.util.Format;

final class ApiValidatorMessageHelper {
    private static final String INCORRECT_TYPE_PARAMETERS_SPECIFIED = "incorrect type parameters specified";

    static String withTypeParametersNonGenericClass(Class<?> rootClass) {
        return INCORRECT_TYPE_PARAMETERS_SPECIFIED + Constants.NL + " -> class " + Format.withoutPackage(rootClass) + " is not generic and does not require type parameters";
    }

    static String ofCollectionElementType(Class<?> elementType, String method) {
        String classWithTypeParams = String.format("%s<%s>", elementType.getSimpleName(), Format.getTypeVariablesCsv(elementType));
        return "invalid usage of " + method + " method" + Constants.NL + Constants.NL + "  -> The argument " + classWithTypeParams + " is a generic class and also requires type parameter(s)," + Constants.NL + "     but this method does not support nested generics." + Constants.NL + Constants.NL + "To resolve this error:" + Constants.NL + Constants.NL + " -> Use one of the methods that accepts a type token, e.g:" + Constants.NL + Constants.NL + "    List<Pair<String, Integer>> list = Instancio.ofList(new TypeToken<Pair<String, Integer>>() {})" + Constants.NL + "            // additional API methods..." + Constants.NL + "            .create();" + Constants.NL + "    or:" + Constants.NL + Constants.NL + "    List<Pair<String, Integer>> list = Instancio.of(new TypeToken<List<Pair<String, Integer>>>(){})" + Constants.NL + "            // additional API methods..." + Constants.NL + "            .create();";
    }

    static String ofMapKeyOrValueType(Class<?> keyOrValue) {
        String classWithTypeParams = String.format("%s<%s>", keyOrValue.getSimpleName(), Format.getTypeVariablesCsv(keyOrValue));
        return "invalid usage of ofMap() method" + Constants.NL + Constants.NL + "  -> The argument " + classWithTypeParams + " is a generic class and also requires type parameter(s)," + Constants.NL + "     but this method does not support nested generics." + Constants.NL + Constants.NL + "To resolve this error:" + Constants.NL + Constants.NL + " -> Use one of the methods that accepts a type token, e.g:" + Constants.NL + Constants.NL + "    Map<Item<String>, Pair<String, Integer>> map = Instancio.ofMap(" + Constants.NL + "                    new TypeToken<Item<String>>() {}," + Constants.NL + "                    new TypeToken<Pair<String, Integer>>() {})" + Constants.NL + "            // additional API methods..." + Constants.NL + "            .create();" + Constants.NL + "    or:" + Constants.NL + Constants.NL + "    Map<Item<String>, Pair<String, Integer>> map = Instancio.of(new TypeToken<Map<Item<String>, Pair<String, Integer>>>(){})" + Constants.NL + "            // additional API methods..." + Constants.NL + "            .create();";
    }

    static String withTypeParametersNestedGenerics(String classWithTypeParams) {
        return INCORRECT_TYPE_PARAMETERS_SPECIFIED + Constants.NL + Constants.NL + "  -> The argument " + classWithTypeParams + " is a generic class and also requires type parameter(s)," + Constants.NL + "     but this method does not support nested generics." + Constants.NL + Constants.NL + "To resolve this error:" + Constants.NL + Constants.NL + " -> Use a type token, e.g:" + Constants.NL + Constants.NL + "    Map<String, List<Integer>> map = Instancio.create(new TypeToken<Map<String, List<Integer>>>(){});" + Constants.NL + Constants.NL + "    or the builder version:" + Constants.NL + Constants.NL + "    Map<String, List<Integer>> map = Instancio.of(new TypeToken<Map<String, List<Integer>>>(){})" + Constants.NL + "            // additional API methods..." + Constants.NL + "            .create();";
    }

    static String withTypeParametersNumberOfParameters(Class<?> rootClass, List<Type> rootTypeParameters) {
        StringBuilder sb = new StringBuilder(1024).append(INCORRECT_TYPE_PARAMETERS_SPECIFIED).append(Constants.NL).append(Constants.NL).append(" -> Class ").append(rootClass.getName()).append(" requires ").append(rootClass.getTypeParameters().length).append(" type parameter(s): ").append(Arrays.toString(rootClass.getTypeParameters())).append(Constants.NL).append(" -> The number of parameters provided was ").append(rootTypeParameters.size());
        if (!rootTypeParameters.isEmpty()) {
            sb.append(": [").append(rootTypeParameters.stream().map(Format::withoutPackage).collect(Collectors.joining(", "))).append(']');
        }
        sb.append(Constants.NL).append(Constants.NL).append("To resolve this error:").append(Constants.NL).append(Constants.NL).append(" -> Specify the correct number of parameters, e.g.").append(Constants.NL).append(Constants.NL).append("    Instancio.of(Map.class).").append(Constants.NL).append("        .withTypeParameters(UUID.class, Person.class)").append(Constants.NL).append("        .create();").append(Constants.NL).append(Constants.NL).append(" -> Or use a type token:").append(Constants.NL).append(Constants.NL).append("    Instancio.create(new TypeToken<Map<UUID, Person>>() {});");
        return sb.toString();
    }

    private ApiValidatorMessageHelper() {
    }
}

