/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.nodes;

import org.instancio.feed.Feed;
import org.instancio.feed.FeedSpec;
import org.instancio.generator.Generator;
import org.instancio.internal.context.SelectorMap;
import org.instancio.internal.feed.InternalFeedSpecResolver;
import org.instancio.internal.nodes.InternalFeedSpecHandler;
import org.instancio.internal.nodes.InternalNode;
import org.instancio.internal.nodes.NodeContext;
import org.instancio.internal.nodes.NodeKind;
import org.instancio.internal.selectors.FeedSelectors;
import org.instancio.internal.selectors.InternalSelector;

final class DefaultFeedSpecHandler
implements InternalFeedSpecHandler {
    private static final InternalFeedSpecHandler NOOP_HANDLER = node -> {};
    private final NodeContext nodeContext;
    private final SelectorMap<Feed> feedSelectorMap;

    private DefaultFeedSpecHandler(NodeContext nodeContext) {
        this.nodeContext = nodeContext;
        this.feedSelectorMap = nodeContext.getFeedSelectorMap();
    }

    static InternalFeedSpecHandler create(NodeContext nodeContext) {
        SelectorMap<Feed> map = nodeContext.getFeedSelectorMap();
        return map.isEmpty() ? NOOP_HANDLER : new DefaultFeedSpecHandler(nodeContext);
    }

    @Override
    public void applyFeedSpecs(InternalNode node) {
        if (node.isIgnored() || !node.is(NodeKind.POJO) && !node.is(NodeKind.RECORD)) {
            return;
        }
        Feed feed = this.feedSelectorMap.getValue(node).orElse(null);
        if (feed == null) {
            return;
        }
        InternalFeedSpecResolver specsResolver = new InternalFeedSpecResolver(feed);
        for (InternalNode child : node.getChildren()) {
            FeedSpec<?> spec = specsResolver.getSpec(child);
            if (spec == null) continue;
            InternalSelector selector = FeedSelectors.forProperty(child);
            this.nodeContext.putGenerator(selector, (Generator)((Object)spec));
        }
    }
}

