/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.feed.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.List;
import org.instancio.feed.DataSource;
import org.instancio.internal.feed.DataLoader;
import org.instancio.internal.util.ErrorMessageUtils;
import org.instancio.internal.util.Fail;

public final class JsonDataLoader
implements DataLoader<List<JsonNode>> {
    @Override
    public List<JsonNode> load(DataSource dataSource) throws Exception {
        try {
            ObjectMapper mapper = new ObjectMapper();
            JsonNode jsonNode = mapper.readTree(this.getInputStream(dataSource));
            ArrayList<JsonNode> results = new ArrayList<JsonNode>(jsonNode.size());
            for (int i = 0; i < jsonNode.size(); ++i) {
                results.add(jsonNode.get(i));
            }
            return results;
        }
        catch (NoClassDefFoundError error) {
            throw Fail.withUsageError(ErrorMessageUtils.jacksonNotOnClasspathErrorMessage(), error);
        }
    }
}

