/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.feed.csv;

import java.util.List;
import java.util.function.BiFunction;
import org.instancio.feed.FormatOptionsProvider;
import org.instancio.internal.feed.CachingDataLoader;
import org.instancio.internal.feed.DataStore;
import org.instancio.internal.feed.InternalFeed;
import org.instancio.internal.feed.InternalFeedContext;
import org.instancio.internal.feed.ResourceHandler;
import org.instancio.internal.feed.csv.CsvDataLoader;
import org.instancio.internal.feed.csv.CsvDataStore;
import org.instancio.internal.feed.csv.CsvFeed;
import org.instancio.internal.feed.csv.InternalCsvFormatOptions;

public final class CsvResourceHandler
implements ResourceHandler {
    private final CachingDataLoader cachingDataLoader = new CachingDataLoader();

    @Override
    public InternalFeed createFeed(InternalFeedContext<?> feedContext) {
        FormatOptionsProvider.FormatOptions options = feedContext.getFormatOptions();
        FormatOptionsProvider.FormatOptions csvOptions = options == null ? InternalCsvFormatOptions.defaults(feedContext.getGeneratorContext().getSettings()) : options;
        CsvDataLoader dataLoader = new CsvDataLoader((InternalCsvFormatOptions)csvOptions);
        BiFunction<String, List<?>, DataStore<?>> tagKeyToDataStoreMapper = (tagKey, data) -> new CsvDataStore((String)tagKey, (List<String[]>)data);
        DataStore<String[]> dataStore = this.cachingDataLoader.loadData(feedContext, dataLoader, tagKeyToDataStoreMapper);
        return new CsvFeed(feedContext, dataStore);
    }
}

