/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.selectors;

import java.lang.reflect.Method;
import java.util.Objects;
import org.instancio.internal.selectors.Target;
import org.jetbrains.annotations.NotNull;

public final class TargetSetter
implements Target {
    private final Method setter;
    private final Class<?> parameterType;

    public TargetSetter(@NotNull Method setter) {
        this.setter = setter;
        this.parameterType = setter.getParameterTypes()[0];
    }

    @Override
    public Class<?> getTargetClass() {
        return this.setter.getDeclaringClass();
    }

    public Method getSetter() {
        return this.setter;
    }

    public Class<?> getParameterType() {
        return this.parameterType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TargetSetter)) {
            return false;
        }
        TargetSetter that = (TargetSetter)o;
        return Objects.equals(this.setter, that.setter);
    }

    public int hashCode() {
        return this.setter == null ? 0 : this.setter.hashCode();
    }

    public String toString() {
        String s = "setter(";
        s = s + this.setter.getDeclaringClass().getSimpleName() + ", ";
        s = s + '\"' + this.setter.getName();
        s = s + '(' + this.parameterType.getSimpleName() + ')';
        return s + "\")";
    }
}

