/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.generator.text;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import org.instancio.Random;
import org.instancio.generator.Generator;
import org.instancio.generator.GeneratorContext;
import org.instancio.generator.GeneratorSpec;
import org.instancio.generator.specs.CsvSpec;
import org.instancio.internal.ApiValidator;
import org.instancio.internal.generator.AbstractGenerator;

public class CsvGenerator
extends AbstractGenerator<String>
implements CsvSpec {
    private int minRows = 1;
    private int maxRows = 10;
    private boolean includeHeader = true;
    private String wrapWith;
    private Predicate<Object> wrapIf = o -> true;
    private String delimiter = ",";
    private String lineSeparator = System.lineSeparator();
    private final List<Column> columns = new ArrayList<Column>();

    public CsvGenerator(GeneratorContext context) {
        super(context);
    }

    @Override
    public String apiMethod() {
        return "csv()";
    }

    @Override
    public CsvGenerator column(String name, GeneratorSpec<?> generatorSpec) {
        return this.column(name, (Generator)generatorSpec);
    }

    @Override
    public CsvGenerator column(String name, Generator<?> generator) {
        this.columns.add(new Column(ApiValidator.notNull(name, "column() name must not be null"), ApiValidator.notNull(generator, "column() generator must not be null")));
        return this;
    }

    @Override
    public CsvGenerator rows(int rows) {
        return this.rows(rows, rows);
    }

    @Override
    public CsvGenerator rows(int min, int max) {
        ApiValidator.isTrue(min >= 0, "min must not be negative: " + min, new Object[0]);
        ApiValidator.isTrue(min <= max, "min must be less than or equal to max: (%s, %s)", min, max);
        this.minRows = min;
        this.maxRows = max;
        return this;
    }

    @Override
    public CsvGenerator noHeader() {
        this.includeHeader = false;
        return this;
    }

    @Override
    public CsvGenerator wrapWith(String wrapWith) {
        this.wrapWith = wrapWith;
        return this;
    }

    @Override
    public CsvGenerator wrapIf(Predicate<Object> wrapIf) {
        this.wrapIf = ApiValidator.notNull(wrapIf, "wrapIf() predicate must not be null");
        return this;
    }

    @Override
    public CsvGenerator delimiter(String delimiter) {
        this.delimiter = delimiter;
        return this;
    }

    @Override
    public CsvGenerator lineSeparator(String lineSeparator) {
        this.lineSeparator = lineSeparator;
        return this;
    }

    @Override
    public CsvGenerator nullable() {
        super.nullable();
        return this;
    }

    @Override
    protected String tryGenerateNonNull(Random random) {
        ApiValidator.isTrue(!this.columns.isEmpty(), "at least 1 column is required to generate CSV", new Object[0]);
        int rows = random.intRange(this.minRows, this.maxRows);
        int initialSize = rows * this.columns.size() * 32;
        StringBuilder sb = new StringBuilder(initialSize);
        int cols = this.columns.size();
        if (this.includeHeader) {
            this.appendHeader(sb, cols);
        }
        for (int r = 0; r < rows; ++r) {
            this.appendRow(sb, cols, random);
            if (r >= rows - 1) continue;
            sb.append(this.lineSeparator);
        }
        return sb.toString();
    }

    private void appendRow(StringBuilder sb, int cols, Random random) {
        for (int c = 0; c < cols; ++c) {
            boolean wrap;
            Generator generator = (Generator)this.columns.get(c).generator;
            Object value = generator.generate(random);
            boolean bl = wrap = this.wrapWith != null && this.wrapIf.test(value);
            if (wrap) {
                sb.append(this.wrapWith);
            }
            sb.append(value);
            if (wrap) {
                sb.append(this.wrapWith);
            }
            if (c >= cols - 1) continue;
            sb.append(this.delimiter);
        }
    }

    private void appendHeader(StringBuilder sb, int cols) {
        for (int c = 0; c < cols; ++c) {
            sb.append(this.columns.get(c).name);
            if (c >= cols - 1) continue;
            sb.append(this.delimiter);
        }
        sb.append(this.lineSeparator);
    }

    private static final class Column {
        private final String name;
        private final GeneratorSpec<?> generator;

        private Column(String name, GeneratorSpec<?> generator) {
            this.name = name;
            this.generator = generator;
        }
    }
}

