/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.feed.csv;

import org.instancio.feed.FormatOptionsProvider;
import org.instancio.internal.ApiValidator;
import org.instancio.settings.FeedDataTrim;
import org.instancio.settings.Keys;
import org.instancio.settings.Settings;

public final class InternalCsvFormatOptions
implements FormatOptionsProvider.FormatOptions {
    private final String commentPrefix;
    private final char delimiter;
    private final FeedDataTrim feedDataTrim;

    static InternalCsvFormatOptions defaults(Settings settings) {
        return InternalCsvFormatOptions.builder().build(settings);
    }

    private InternalCsvFormatOptions(Builder builder, Settings settings) {
        this.commentPrefix = builder.commentPrefix;
        this.delimiter = builder.delimiter;
        this.feedDataTrim = builder.feedDataTrim != null ? builder.feedDataTrim : settings.get(Keys.FEED_DATA_TRIM);
    }

    String getCommentPrefix() {
        return this.commentPrefix;
    }

    char getDelimiter() {
        return this.delimiter;
    }

    FeedDataTrim getFeedDataTrim() {
        return this.feedDataTrim;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    implements FormatOptionsProvider.FormatOptions.CsvFormatOptions {
        private static final String DEFAULT_COMMENT_PREFIX = "#";
        private static final char DEFAULT_DELIMITER = ',';
        private String commentPrefix = "#";
        private char delimiter = (char)44;
        private FeedDataTrim feedDataTrim;

        private Builder() {
        }

        @Override
        public Builder commentPrefix(String commentPrefix) {
            this.commentPrefix = ApiValidator.notNull(commentPrefix, "'commentPrefix' must not be null");
            return this;
        }

        @Override
        public Builder delimiter(char delimiter) {
            this.delimiter = delimiter;
            return this;
        }

        @Override
        public Builder trim(FeedDataTrim feedDataTrim) {
            this.feedDataTrim = feedDataTrim;
            return this;
        }

        public InternalCsvFormatOptions build(Settings settings) {
            return new InternalCsvFormatOptions(this, settings);
        }
    }
}

