/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal;

import org.instancio.generator.AfterGenerate;
import org.instancio.internal.ArrayElementNodePopulationFilter;
import org.instancio.internal.NodePopulationFilter;
import org.instancio.internal.context.ModelContext;
import org.instancio.internal.nodes.InternalNode;
import org.instancio.internal.nodes.NodeKind;
import org.instancio.internal.util.ReflectionUtils;
import org.instancio.settings.AssignmentType;
import org.instancio.settings.Keys;
import org.instancio.settings.OnSetMethodNotFound;
import org.jetbrains.annotations.Nullable;

final class NodeFilter
implements NodePopulationFilter {
    private final NodePopulationFilter arrayNodeFilter = new ArrayElementNodePopulationFilter();
    private final boolean isMethodAssignment;
    private final boolean overwriteExistingValues;
    private final OnSetMethodNotFound onSetMethodNotFound;
    private final ModelContext<?> context;

    NodeFilter(ModelContext<?> context) {
        this.context = context;
        this.isMethodAssignment = context.getSettings().get(Keys.ASSIGNMENT_TYPE) == AssignmentType.METHOD;
        this.onSetMethodNotFound = context.getSettings().get(Keys.ON_SET_METHOD_NOT_FOUND);
        this.overwriteExistingValues = context.getSettings().get(Keys.OVERWRITE_EXISTING_VALUES);
    }

    @Override
    public NodePopulationFilter.NodeFilterResult filter(InternalNode node, AfterGenerate afterGenerate, @Nullable Object owner) {
        if (node.isIgnored() || afterGenerate == AfterGenerate.DO_NOT_MODIFY) {
            return NodePopulationFilter.NodeFilterResult.SKIP;
        }
        if (this.isMethodAssignment && node.getSetter() == null && node.getField() != null && this.onSetMethodNotFound == OnSetMethodNotFound.IGNORE) {
            return NodePopulationFilter.NodeFilterResult.SKIP;
        }
        if (node.getParent().is(NodeKind.RECORD)) {
            return NodePopulationFilter.NodeFilterResult.POPULATE;
        }
        if (this.context.getGenerator(node).isPresent()) {
            return NodePopulationFilter.NodeFilterResult.GENERATE;
        }
        if (node.getParent().is(NodeKind.ARRAY)) {
            return this.arrayNodeFilter.filter(node, afterGenerate, owner);
        }
        if (!this.overwriteExistingValues && node.getField() != null && ReflectionUtils.hasNonNullOrNonDefaultPrimitiveValue(node.getField(), owner)) {
            return NodeFilter.getResultForNode(node);
        }
        if (afterGenerate == AfterGenerate.POPULATE_NULLS) {
            if (node.getField() != null && ReflectionUtils.hasNonNullValue(node.getField(), owner)) {
                return NodeFilter.getResultForNode(node);
            }
            return NodePopulationFilter.NodeFilterResult.GENERATE;
        }
        if (afterGenerate == AfterGenerate.POPULATE_NULLS_AND_DEFAULT_PRIMITIVES) {
            if (node.getField() != null && ReflectionUtils.hasNonNullOrNonDefaultPrimitiveValue(node.getField(), owner)) {
                return NodeFilter.getResultForNode(node);
            }
            return NodePopulationFilter.NodeFilterResult.GENERATE;
        }
        return afterGenerate == AfterGenerate.POPULATE_ALL ? NodePopulationFilter.NodeFilterResult.GENERATE : NodePopulationFilter.NodeFilterResult.POPULATE;
    }

    private static NodePopulationFilter.NodeFilterResult getResultForNode(InternalNode node) {
        return NodeFilter.isPojoOrDataStructure(node) ? NodePopulationFilter.NodeFilterResult.POPULATE : NodePopulationFilter.NodeFilterResult.SKIP;
    }

    private static boolean isPojoOrDataStructure(InternalNode node) {
        return node.is(NodeKind.POJO) || node.is(NodeKind.COLLECTION) || node.is(NodeKind.MAP) || node.is(NodeKind.ARRAY);
    }
}

