/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.util;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZonedDateTime;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import org.instancio.internal.util.Fail;

public final class StringConverters {
    private static final Map<Class<?>, Function<String, ?>> MAPPERS = Collections.unmodifiableMap(StringConverters.getFunctionMap());

    private static Map<Class<?>, Function<String, ?>> getFunctionMap() {
        HashMap map = new HashMap();
        map.put(String.class, Function.identity());
        map.put(Boolean.class, Boolean::valueOf);
        map.put(Character.class, s -> Character.valueOf(s.charAt(0)));
        map.put(Integer.class, Integer::valueOf);
        map.put(Long.class, Long::valueOf);
        map.put(Byte.class, Byte::valueOf);
        map.put(Short.class, Short::valueOf);
        map.put(Float.class, Float::valueOf);
        map.put(Double.class, Double::valueOf);
        map.put(BigInteger.class, BigInteger::new);
        map.put(BigDecimal.class, BigDecimal::new);
        map.put(Instant.class, Instant::parse);
        map.put(LocalTime.class, LocalTime::parse);
        map.put(LocalDate.class, LocalDate::parse);
        map.put(LocalDateTime.class, LocalDateTime::parse);
        map.put(OffsetTime.class, OffsetTime::parse);
        map.put(OffsetDateTime.class, OffsetDateTime::parse);
        map.put(ZonedDateTime.class, ZonedDateTime::parse);
        map.put(YearMonth.class, YearMonth::parse);
        map.put(Year.class, Year::parse);
        map.put(UUID.class, UUID::fromString);
        return map;
    }

    public static <T> Function<String, T> getConverter(Class<T> targetType) {
        Function<String, ?> mappingFn = MAPPERS.get(targetType);
        if (mappingFn != null) {
            return mappingFn;
        }
        if (targetType.isEnum()) {
            return value -> Enum.valueOf(targetType, value);
        }
        return source -> {
            throw Fail.withUsageError("cannot map value '%s' (unsupported target type: %s)", source, targetType.getTypeName());
        };
    }

    private StringConverters() {
    }
}

