/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.nodes.resolvers;

import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.instancio.internal.nodes.NodeKind;
import org.instancio.internal.nodes.NodeKindResolver;
import org.instancio.internal.spi.InternalServiceProvider;

class NodeKindContainerResolver
implements NodeKindResolver {
    private final List<InternalServiceProvider> serviceProviders;

    NodeKindContainerResolver(List<InternalServiceProvider> serviceProviders) {
        this.serviceProviders = serviceProviders;
    }

    @Override
    public Optional<NodeKind> resolve(Class<?> targetClass) {
        if (targetClass == Optional.class || targetClass == EnumSet.class || Map.Entry.class.isAssignableFrom(targetClass) || this.isSpiDefinedContainer(targetClass)) {
            return Optional.of(NodeKind.CONTAINER);
        }
        return Optional.empty();
    }

    private boolean isSpiDefinedContainer(Class<?> targetClass) {
        for (InternalServiceProvider p : this.serviceProviders) {
            InternalServiceProvider.InternalContainerFactoryProvider provider = p.getContainerFactoryProvider();
            if (provider == null || !provider.isContainer(targetClass)) continue;
            return true;
        }
        return false;
    }
}

