/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.generation;

import java.util.Optional;
import org.instancio.generator.Generator;
import org.instancio.internal.context.ModelContext;
import org.instancio.internal.generation.NodeHandler;
import org.instancio.internal.generation.UserSuppliedGeneratorProcessor;
import org.instancio.internal.generator.GeneratorResult;
import org.instancio.internal.nodes.InternalNode;
import org.jetbrains.annotations.NotNull;

final class UserSuppliedGeneratorHandler
implements NodeHandler {
    private final ModelContext<?> modelContext;
    private final UserSuppliedGeneratorProcessor userSuppliedGeneratorProcessor;

    private UserSuppliedGeneratorHandler(ModelContext<?> modelContext, UserSuppliedGeneratorProcessor userSuppliedGeneratorProcessor) {
        this.modelContext = modelContext;
        this.userSuppliedGeneratorProcessor = userSuppliedGeneratorProcessor;
    }

    static NodeHandler create(ModelContext<?> modelContext, UserSuppliedGeneratorProcessor userSuppliedGeneratorProcessor) {
        return modelContext.getSelectorMaps().hasGenerators() ? new UserSuppliedGeneratorHandler(modelContext, userSuppliedGeneratorProcessor) : NOOP_HANDLER;
    }

    @Override
    @NotNull
    public GeneratorResult getResult(@NotNull InternalNode node) {
        Optional<Generator<?>> generatorOpt = this.modelContext.getGenerator(node);
        if (!generatorOpt.isPresent()) {
            return GeneratorResult.emptyResult();
        }
        return this.userSuppliedGeneratorProcessor.getGeneratorResult(node, generatorOpt.get());
    }
}

