/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.feed.csv;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.instancio.feed.DataSource;
import org.instancio.internal.feed.DataLoader;
import org.instancio.internal.feed.csv.InternalCsvFormatOptions;
import org.instancio.settings.FeedDataTrim;

public final class CsvDataLoader
implements DataLoader<List<String[]>> {
    private final FeedDataTrim feedDataTrim;
    private final String commentChar;
    private final Pattern delimiterMatcher;

    CsvDataLoader(InternalCsvFormatOptions formatOptions) {
        this.feedDataTrim = formatOptions.getFeedDataTrim();
        this.commentChar = formatOptions.getCommentPrefix();
        this.delimiterMatcher = Pattern.compile(String.valueOf(formatOptions.getDelimiter()), 16);
    }

    @Override
    public List<String[]> load(DataSource dataSource) throws Exception {
        try (BufferedReader br = new BufferedReader(new InputStreamReader(this.getInputStream(dataSource)));){
            String line;
            ArrayList<String[]> results = new ArrayList<String[]>();
            while ((line = br.readLine()) != null) {
                if (line.isEmpty() || line.startsWith(this.commentChar)) continue;
                String[] tokens = this.delimiterMatcher.split(line);
                for (int i = 0; i < tokens.length; ++i) {
                    String val = this.feedDataTrim == FeedDataTrim.NONE ? tokens[i] : tokens[i].trim();
                    tokens[i] = val.isEmpty() ? null : val;
                }
                results.add(tokens);
            }
            ArrayList<String[]> arrayList = results;
            return arrayList;
        }
    }
}

