/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.util;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class NumberUtils {
    private static final int RADIX_DECIMAL = 10;
    private static final BigDecimal HUNDRED = new BigDecimal(100);
    private static final Map<Class<?>, Number> NUMERIC_MIN_VALUES = new HashMap(80);
    private static final Map<Class<?>, Number> NUMERIC_MAX_VALUES = new HashMap(80);
    private static final Map<Class<?>, Function<Long, Number>> CONVERT_FROM_LONG_FN_MAP = new HashMap();
    private static final Map<Class<?>, Function<BigDecimal, Number>> CONVERT_FROM_BD_FN_MAP = new HashMap();

    private static BigDecimal round(BigDecimal b) {
        return b.setScale(0, RoundingMode.HALF_UP);
    }

    public static <T extends Number> T getMinValue(Class<?> klass) {
        return (T)NUMERIC_MIN_VALUES.get(klass);
    }

    public static <T extends Number> T getMaxValue(Class<?> klass) {
        return (T)NUMERIC_MAX_VALUES.get(klass);
    }

    public static <T extends Number> Function<Long, T> longConverter(Class<?> klass) {
        return CONVERT_FROM_LONG_FN_MAP.get(klass);
    }

    public static <T extends Number> Function<BigDecimal, T> bigDecimalConverter(Class<?> klass) {
        return CONVERT_FROM_BD_FN_MAP.get(klass);
    }

    public static <T extends Number> T calculateNewMin(@Nullable T curMin, @NotNull T newMax, int percentage) {
        BigDecimal newMinBD;
        BigDecimal curMinBD;
        if (Objects.equals(newMax, curMin)) {
            return curMin;
        }
        BigDecimal newMaxBD = NumberUtils.toBigDecimal(newMax);
        if (newMaxBD.compareTo(BigDecimal.ZERO) == 0) {
            newMaxBD = BigDecimal.ONE.negate();
        }
        if ((curMinBD = NumberUtils.toBigDecimal(curMin)) == null || curMinBD.compareTo(newMaxBD) > 0) {
            BigDecimal bdPercentage = new BigDecimal(percentage);
            BigDecimal absDelta = newMaxBD.multiply(bdPercentage.divide(HUNDRED, 3, RoundingMode.HALF_UP)).abs();
            BigDecimal absoluteMin = NumberUtils.toBigDecimal(NumberUtils.getMinValue(newMaxBD.getClass()));
            newMinBD = absoluteMin != null && absoluteMin.add(absDelta).compareTo(newMaxBD) <= 0 ? newMaxBD.subtract(absDelta) : absoluteMin;
        } else {
            newMinBD = curMinBD;
        }
        Class<?> numberClass = newMax.getClass();
        Function<BigDecimal, BigDecimal> fn = NumberUtils.bigDecimalConverter(numberClass);
        return (T)((Number)fn.apply(newMinBD));
    }

    public static <T extends Number> T calculateNewMax(@Nullable T curMax, @NotNull T newMin, int percentage) {
        BigDecimal newMaxBD;
        BigDecimal curMaxBD;
        if (Objects.equals(newMin, curMax)) {
            return curMax;
        }
        BigDecimal newMinBD = NumberUtils.toBigDecimal(newMin);
        if (newMinBD.compareTo(BigDecimal.ZERO) == 0) {
            newMinBD = BigDecimal.ONE;
        }
        if ((curMaxBD = NumberUtils.toBigDecimal(curMax)) == null || curMaxBD.compareTo(newMinBD) < 0) {
            BigDecimal bdPercentage = new BigDecimal(percentage);
            BigDecimal absDelta = newMinBD.multiply(bdPercentage.divide(HUNDRED, 3, RoundingMode.HALF_UP)).abs();
            BigDecimal absoluteMax = NumberUtils.toBigDecimal(NumberUtils.getMaxValue(newMin.getClass()));
            newMaxBD = absoluteMax != null && absoluteMax.subtract(absDelta).compareTo(newMinBD) >= 0 ? newMinBD.add(absDelta) : absoluteMax;
        } else {
            newMaxBD = curMaxBD;
        }
        Class<?> numberClass = newMin.getClass();
        Function<BigDecimal, BigDecimal> fn = NumberUtils.bigDecimalConverter(numberClass);
        return (T)((Number)fn.apply(newMaxBD));
    }

    public static Integer calculateNewMinSize(@Nullable Integer curMin, Integer newMax) {
        return Math.max(0, NumberUtils.calculateNewMin(curMin, newMax, 50));
    }

    public static Integer calculateNewMaxSize(@Nullable Integer curMax, Integer newMin) {
        return NumberUtils.calculateNewMax(curMax, newMin, 50);
    }

    public static int sumDigits(int num) {
        int sum = 0;
        for (int n = num; n > 0; n /= 10) {
            sum += n % 10;
        }
        return sum;
    }

    public static int toDigitInt(char digit) {
        return Character.digit(digit, 10);
    }

    public static char toDigitChar(int digit) {
        return Character.forDigit(digit, 10);
    }

    public static boolean isZero(BigDecimal value) {
        return value.compareTo(BigDecimal.ZERO) == 0;
    }

    private static BigDecimal toBigDecimal(Number n) {
        return n == null ? null : new BigDecimal(n.toString());
    }

    private NumberUtils() {
    }

    static {
        NUMERIC_MIN_VALUES.put(Byte.class, (byte)-128);
        NUMERIC_MIN_VALUES.put(Short.class, (short)Short.MIN_VALUE);
        NUMERIC_MIN_VALUES.put(Integer.class, Integer.MIN_VALUE);
        NUMERIC_MIN_VALUES.put(Long.class, Long.MIN_VALUE);
        NUMERIC_MIN_VALUES.put(Float.class, Float.valueOf(Float.MIN_VALUE));
        NUMERIC_MIN_VALUES.put(Double.class, Double.MIN_VALUE);
        NUMERIC_MIN_VALUES.put(Byte.TYPE, (byte)-128);
        NUMERIC_MIN_VALUES.put(Short.TYPE, (short)Short.MIN_VALUE);
        NUMERIC_MIN_VALUES.put(Integer.TYPE, Integer.MIN_VALUE);
        NUMERIC_MIN_VALUES.put(Long.TYPE, Long.MIN_VALUE);
        NUMERIC_MIN_VALUES.put(Float.TYPE, Float.valueOf(Float.MIN_VALUE));
        NUMERIC_MIN_VALUES.put(Double.TYPE, Double.MIN_VALUE);
        NUMERIC_MIN_VALUES.put(BigInteger.class, BigInteger.valueOf(Long.MIN_VALUE));
        NUMERIC_MIN_VALUES.put(BigDecimal.class, new BigDecimal(Long.MIN_VALUE));
        NUMERIC_MAX_VALUES.put(Byte.class, (byte)127);
        NUMERIC_MAX_VALUES.put(Short.class, (short)Short.MAX_VALUE);
        NUMERIC_MAX_VALUES.put(Integer.class, Integer.MAX_VALUE);
        NUMERIC_MAX_VALUES.put(Long.class, Long.MAX_VALUE);
        NUMERIC_MAX_VALUES.put(Float.class, Float.valueOf(Float.MAX_VALUE));
        NUMERIC_MAX_VALUES.put(Double.class, Double.MAX_VALUE);
        NUMERIC_MAX_VALUES.put(Byte.TYPE, (byte)127);
        NUMERIC_MAX_VALUES.put(Short.TYPE, (short)Short.MAX_VALUE);
        NUMERIC_MAX_VALUES.put(Integer.TYPE, Integer.MAX_VALUE);
        NUMERIC_MAX_VALUES.put(Long.TYPE, Long.MAX_VALUE);
        NUMERIC_MAX_VALUES.put(Float.TYPE, Float.valueOf(Float.MAX_VALUE));
        NUMERIC_MAX_VALUES.put(Double.TYPE, Double.MAX_VALUE);
        NUMERIC_MAX_VALUES.put(BigInteger.class, BigInteger.valueOf(Long.MAX_VALUE));
        NUMERIC_MAX_VALUES.put(BigDecimal.class, new BigDecimal(Long.MAX_VALUE));
        CONVERT_FROM_LONG_FN_MAP.put(Byte.TYPE, Long::byteValue);
        CONVERT_FROM_LONG_FN_MAP.put(Short.TYPE, Long::shortValue);
        CONVERT_FROM_LONG_FN_MAP.put(Integer.TYPE, Long::intValue);
        CONVERT_FROM_LONG_FN_MAP.put(Long.TYPE, l -> l);
        CONVERT_FROM_LONG_FN_MAP.put(Float.TYPE, Long::floatValue);
        CONVERT_FROM_LONG_FN_MAP.put(Double.TYPE, Long::doubleValue);
        CONVERT_FROM_LONG_FN_MAP.put(Byte.class, Long::byteValue);
        CONVERT_FROM_LONG_FN_MAP.put(Short.class, Long::shortValue);
        CONVERT_FROM_LONG_FN_MAP.put(Integer.class, Long::intValue);
        CONVERT_FROM_LONG_FN_MAP.put(Long.class, l -> l);
        CONVERT_FROM_LONG_FN_MAP.put(Float.class, Long::floatValue);
        CONVERT_FROM_LONG_FN_MAP.put(Double.class, Long::doubleValue);
        CONVERT_FROM_LONG_FN_MAP.put(BigDecimal.class, BigDecimal::new);
        CONVERT_FROM_LONG_FN_MAP.put(BigInteger.class, BigInteger::valueOf);
        CONVERT_FROM_BD_FN_MAP.put(Byte.TYPE, b -> NumberUtils.round(b).byteValue());
        CONVERT_FROM_BD_FN_MAP.put(Short.TYPE, b -> NumberUtils.round(b).shortValue());
        CONVERT_FROM_BD_FN_MAP.put(Integer.TYPE, b -> NumberUtils.round(b).intValue());
        CONVERT_FROM_BD_FN_MAP.put(Long.TYPE, b -> NumberUtils.round(b).longValue());
        CONVERT_FROM_BD_FN_MAP.put(Float.TYPE, BigDecimal::floatValue);
        CONVERT_FROM_BD_FN_MAP.put(Double.TYPE, BigDecimal::doubleValue);
        CONVERT_FROM_BD_FN_MAP.put(Byte.class, b -> NumberUtils.round(b).byteValue());
        CONVERT_FROM_BD_FN_MAP.put(Short.class, b -> NumberUtils.round(b).shortValue());
        CONVERT_FROM_BD_FN_MAP.put(Integer.class, b -> NumberUtils.round(b).intValue());
        CONVERT_FROM_BD_FN_MAP.put(Long.class, b -> NumberUtils.round(b).longValue());
        CONVERT_FROM_BD_FN_MAP.put(Float.class, BigDecimal::floatValue);
        CONVERT_FROM_BD_FN_MAP.put(Double.class, BigDecimal::doubleValue);
        CONVERT_FROM_BD_FN_MAP.put(BigDecimal.class, b -> b);
        CONVERT_FROM_BD_FN_MAP.put(BigInteger.class, b -> NumberUtils.round(b).toBigInteger());
    }
}

