/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.spi;

import java.util.List;
import org.instancio.internal.spi.ProviderEntry;
import org.instancio.internal.util.ServiceLoaders;
import org.instancio.spi.InstancioServiceProvider;
import org.instancio.spi.ServiceProviderContext;
import org.jetbrains.annotations.VisibleForTesting;

public final class Providers {
    private final List<ProviderEntry<InstancioServiceProvider.GeneratorProvider>> generatorProviders;
    private final List<ProviderEntry<InstancioServiceProvider.TypeResolver>> typeResolvers;
    private final List<ProviderEntry<InstancioServiceProvider.TypeInstantiator>> typeInstantiators;
    private final List<ProviderEntry<InstancioServiceProvider.SetterMethodResolver>> setterMethodResolvers;
    private final List<ProviderEntry<InstancioServiceProvider.AnnotationProcessor>> annotationProcessors;

    public Providers(ServiceProviderContext context) {
        this(ServiceLoaders.loadAll(InstancioServiceProvider.class), context);
    }

    @VisibleForTesting
    Providers(List<InstancioServiceProvider> spList, ServiceProviderContext context) {
        spList.forEach(sp -> sp.init(context));
        this.generatorProviders = ProviderEntry.from(spList, InstancioServiceProvider::getGeneratorProvider);
        this.typeResolvers = ProviderEntry.from(spList, InstancioServiceProvider::getTypeResolver);
        this.typeInstantiators = ProviderEntry.from(spList, InstancioServiceProvider::getTypeInstantiator);
        this.setterMethodResolvers = ProviderEntry.from(spList, InstancioServiceProvider::getSetterMethodResolver);
        this.annotationProcessors = ProviderEntry.from(spList, InstancioServiceProvider::getAnnotationProcessor);
    }

    public List<ProviderEntry<InstancioServiceProvider.GeneratorProvider>> getGeneratorProviders() {
        return this.generatorProviders;
    }

    public List<ProviderEntry<InstancioServiceProvider.TypeResolver>> getTypeResolvers() {
        return this.typeResolvers;
    }

    public List<ProviderEntry<InstancioServiceProvider.TypeInstantiator>> getTypeInstantiators() {
        return this.typeInstantiators;
    }

    public List<ProviderEntry<InstancioServiceProvider.SetterMethodResolver>> getSetterMethodResolvers() {
        return this.setterMethodResolvers;
    }

    public List<ProviderEntry<InstancioServiceProvider.AnnotationProcessor>> getAnnotationProcessors() {
        return this.annotationProcessors;
    }
}

