/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.nodes;

import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.instancio.exception.InstancioException;
import org.instancio.internal.nodes.ClassData;
import org.instancio.internal.nodes.DeclaredAndInheritedMemberCollector;
import org.instancio.internal.nodes.InternalNode;
import org.instancio.internal.nodes.MemberPair;
import org.instancio.internal.nodes.NodeContext;
import org.instancio.internal.nodes.NodeCreator;
import org.instancio.internal.nodes.NodeKind;
import org.instancio.internal.nodes.OriginSelectorValidator;
import org.instancio.internal.nodes.TypeHelper;
import org.instancio.internal.util.ObjectUtils;
import org.instancio.internal.util.ReflectionUtils;
import org.instancio.internal.util.TypeUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NodeFactory {
    private static final Logger LOG = LoggerFactory.getLogger(NodeFactory.class);
    private final DeclaredAndInheritedMemberCollector memberCollector;
    private final NodeContext nodeContext;
    private final NodeCreator nodeCreator;
    private final TypeHelper typeHelper;
    private final OriginSelectorValidator originSelectorValidator;

    public NodeFactory(NodeContext nodeContext) {
        this.nodeContext = nodeContext;
        this.nodeCreator = new NodeCreator(nodeContext);
        this.typeHelper = new TypeHelper(nodeContext);
        this.originSelectorValidator = new OriginSelectorValidator(nodeContext);
        this.memberCollector = new DeclaredAndInheritedMemberCollector(nodeContext.getSettings());
    }

    public InternalNode createRootNode(Type type) {
        InternalNode root = this.nodeCreator.createNode(type, null, null);
        ArrayDeque<InternalNode> nodeQueue = new ArrayDeque<InternalNode>();
        nodeQueue.offer(root);
        while (!nodeQueue.isEmpty()) {
            InternalNode node = (InternalNode)nodeQueue.poll();
            if (node.isCyclic() || !node.getChildren().isEmpty()) continue;
            this.originSelectorValidator.checkNode(node);
            List<InternalNode> children = this.createChildren(node);
            node.setChildren(children);
            nodeQueue.addAll(children);
        }
        return root;
    }

    @NotNull
    private List<InternalNode> createChildren(@NotNull InternalNode node) {
        List<InternalNode> children;
        if (node.isIgnored()) {
            return Collections.emptyList();
        }
        if (node.getDepth() >= this.nodeContext.getMaxDepth()) {
            LOG.trace("Maximum depth ({}) reached {}", (Object)this.nodeContext.getMaxDepth(), (Object)node);
            return Collections.emptyList();
        }
        Type type = node.getType();
        if (type instanceof Class) {
            children = node.is(NodeKind.JDK) ? Collections.emptyList() : this.createChildrenOfClass(node);
        } else if (type instanceof ParameterizedType) {
            children = this.createChildrenOfParameterizedType(node);
        } else if (type instanceof GenericArrayType) {
            children = this.createChildrenOfGenericArrayNode(node);
        } else {
            throw new InstancioException("Unexpected node type: " + type);
        }
        return children;
    }

    private List<InternalNode> createChildrenOfClass(InternalNode node) {
        Class<?> targetClass = node.getTargetClass();
        if (node.isContainer()) {
            Type[] types;
            Type[] typeArray;
            if (targetClass.isArray()) {
                Type[] typeArray2 = new Type[1];
                typeArray = typeArray2;
                typeArray2[0] = targetClass.getComponentType();
            } else {
                typeArray = types = targetClass.getTypeParameters();
            }
            if (types.length == 0) {
                types = TypeUtils.getGenericSuperclassTypeArguments(targetClass);
            }
            return this.createContainerNodeChildren(node, types);
        }
        return this.createChildrenFromMembers(node);
    }

    private List<InternalNode> createChildrenOfParameterizedType(InternalNode node) {
        ParameterizedType type = (ParameterizedType)node.getType();
        return node.isContainer() ? this.createContainerNodeChildren(node, type.getActualTypeArguments()) : this.createChildrenFromMembers(node);
    }

    private List<InternalNode> createChildrenOfGenericArrayNode(InternalNode node) {
        GenericArrayType type = (GenericArrayType)node.getType();
        Type gcType = type.getGenericComponentType();
        if (gcType instanceof TypeVariable) {
            gcType = this.typeHelper.resolveTypeVariable((TypeVariable)gcType, node);
        }
        return this.createContainerNodeChildren(node, gcType);
    }

    private List<InternalNode> createContainerNodeChildren(InternalNode parent, Type ... types) {
        ArrayList<InternalNode> results = new ArrayList<InternalNode>(types.length);
        for (Type type : types) {
            InternalNode node = this.nodeCreator.createNode(type, null, parent);
            if (node == null) continue;
            results.add(node);
        }
        return results;
    }

    private List<InternalNode> createChildrenFromMembers(InternalNode node) {
        ClassData classData = this.memberCollector.getClassData(node);
        ArrayList<InternalNode> children = new ArrayList<InternalNode>();
        for (MemberPair memberPair : classData.getMemberPairs()) {
            Field field = memberPair.getField();
            Method setter = memberPair.getSetter();
            Type type = ObjectUtils.defaultIfNull(field.getGenericType(), field.getType());
            InternalNode child = this.nodeCreator.createNode(type, field, setter, node);
            if (child == null) continue;
            children.add(child);
        }
        for (Method method : classData.getUnmatchedSetters()) {
            Type type = ReflectionUtils.getSetMethodParameterType(method);
            InternalNode child = this.nodeCreator.createNode(type, null, method, node);
            if (child == null) continue;
            children.add(child);
        }
        return children;
    }
}

