/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.generator.net;

import java.net.MalformedURLException;
import java.net.URL;
import org.instancio.Random;
import org.instancio.generator.Generator;
import org.instancio.generator.GeneratorContext;
import org.instancio.generator.specs.URLAsGeneratorSpec;
import org.instancio.generator.specs.URLSpec;
import org.instancio.internal.generator.net.AbstractURIGenerator;
import org.instancio.internal.util.Fail;
import org.instancio.internal.util.StringUtils;
import org.instancio.support.Global;

public class URLGenerator
extends AbstractURIGenerator<URL>
implements URLSpec,
URLAsGeneratorSpec {
    public URLGenerator() {
        this(Global.generatorContext());
    }

    public URLGenerator(GeneratorContext context) {
        super(context);
    }

    @Override
    public String apiMethod() {
        return "url()";
    }

    @Override
    public URLGenerator protocol(String ... protocols) {
        this.withScheme(protocols);
        return this;
    }

    @Override
    public URLGenerator port(int port) {
        this.withPort(port);
        return this;
    }

    @Override
    public URLGenerator randomPort() {
        this.withRandomPort();
        return this;
    }

    @Override
    public URLGenerator host(Generator<String> hostGenerator) {
        this.withHost(hostGenerator);
        return this;
    }

    @Override
    public URLGenerator file(Generator<String> fileGenerator) {
        this.withPath(fileGenerator);
        return this;
    }

    @Override
    public URLGenerator nullable() {
        super.nullable();
        return this;
    }

    @Override
    protected URL tryGenerateNonNull(Random random) {
        String protocol = this.getScheme(random);
        String host = this.getHost(random);
        int portNumber = this.getPort(random);
        String file = this.getPath(random, "");
        try {
            return new URL(protocol, host, portNumber, file);
        }
        catch (MalformedURLException ex) {
            String params = String.format("%n  protocol: %s%n  host: %s%n  port: %s%n  file: %s", StringUtils.singleQuote(protocol), StringUtils.singleQuote(host), portNumber, StringUtils.singleQuote(file));
            throw Fail.withUsageError("error generating a URL using parameters: " + params, ex);
        }
    }
}

