/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.generator.lang;

import java.util.ArrayList;
import java.util.List;
import org.instancio.Random;
import org.instancio.generator.GeneratorContext;
import org.instancio.generator.specs.NumberAsGeneratorSpec;
import org.instancio.internal.ApiValidator;
import org.instancio.internal.generator.AbstractGenerator;
import org.instancio.internal.util.Range;

public abstract class AbstractRandomNumberGeneratorSpec<T extends Number>
extends AbstractGenerator<T>
implements NumberAsGeneratorSpec<T> {
    private T min;
    private T max;
    private final List<Range<T>> rangeStack = new ArrayList<Range<T>>();

    protected AbstractRandomNumberGeneratorSpec(GeneratorContext context, T min, T max, boolean nullable) {
        super(context);
        super.nullable(nullable);
        this.min = min;
        this.max = max;
    }

    protected final T getMin() {
        return this.min;
    }

    protected final T getMax() {
        return this.max;
    }

    @Override
    public NumberAsGeneratorSpec<T> min(T min) {
        this.min = (Number)ApiValidator.notNull(min, "'min' must not be null");
        return this;
    }

    @Override
    public NumberAsGeneratorSpec<T> max(T max) {
        this.max = (Number)ApiValidator.notNull(max, "'max' must not be null");
        return this;
    }

    @Override
    public NumberAsGeneratorSpec<T> nullable() {
        super.nullable();
        return this;
    }

    @Override
    public NumberAsGeneratorSpec<T> nullable(boolean isNullable) {
        super.nullable(isNullable);
        return this;
    }

    @Override
    public NumberAsGeneratorSpec<T> range(T min, T max) {
        this.min = (Number)ApiValidator.notNull(min, "'min' must not be null");
        this.max = (Number)ApiValidator.notNull(max, "'max' must not be null");
        this.rangeStack.add(Range.of(min, max));
        return this;
    }

    @Override
    public T generate(Random random) {
        if (random.diceRoll(this.isNullable())) {
            return null;
        }
        this.setRange(random);
        return (T)((Number)this.tryGenerateNonNull(random));
    }

    private void setRange(Random random) {
        if (!this.rangeStack.isEmpty()) {
            Range<T> range = random.oneOf(this.rangeStack);
            this.min = (Number)range.min();
            this.max = (Number)range.max();
        }
    }
}

