/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.instancio.internal.generator.GeneratorResult;
import org.instancio.internal.nodes.InternalNode;
import org.instancio.internal.spi.InternalServiceProvider;

class ContainerFactoriesHandler {
    private final List<InternalServiceProvider> internalServiceProviders;

    ContainerFactoriesHandler(List<InternalServiceProvider> providers) {
        this.internalServiceProviders = providers;
    }

    GeneratorResult substituteResult(InternalNode node, GeneratorResult result) {
        if (this.internalServiceProviders.isEmpty()) {
            return result;
        }
        ArrayList typeArgs = new ArrayList(node.getChildren().size());
        for (InternalNode child : node.getChildren()) {
            typeArgs.add(child.getTargetClass());
        }
        for (InternalServiceProvider isp : this.internalServiceProviders) {
            Function fn;
            InternalServiceProvider.InternalContainerFactoryProvider cfp = isp.getContainerFactoryProvider();
            if (cfp == null || (fn = cfp.getMappingFunction(node.getTargetClass(), typeArgs)) == null) continue;
            Object replacement = fn.apply(result.getValue());
            return GeneratorResult.create(replacement, result.getHints());
        }
        return result;
    }
}

