/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.support;

import java.math.BigInteger;
import java.security.SecureRandom;
import org.instancio.documentation.InternalApi;

@InternalApi
public final class Seeds {
    private static final int NUM_BITS_62 = 62;
    private static final SecureRandom SECURE_RANDOM = new SecureRandom();

    private Seeds() {
    }

    public static long randomSeed() {
        return new BigInteger(62, SECURE_RANDOM).longValue();
    }

    public static enum Source {
        MANUAL(".withSeed()"),
        WITH_SETTINGS_BUILDER(".withSettings()"),
        WITH_SETTINGS_ANNOTATION("@WithSettings"),
        SEED_ANNOTATION("@Seed"),
        GLOBAL("instancio.properties"),
        RANDOM("random seed");

        private final String description;

        private Source(String description) {
            this.description = description;
        }

        public String getDescription() {
            return this.description;
        }
    }
}

