/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.selectors;

import java.util.Objects;
import org.instancio.internal.selectors.Target;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TargetSetterName
implements Target {
    private final Class<?> targetClass;
    private final String methodName;
    private final Class<?> parameterType;

    public TargetSetterName(@Nullable Class<?> targetClass, @NotNull String methodName, @Nullable Class<?> parameterType) {
        this.targetClass = targetClass;
        this.methodName = methodName;
        this.parameterType = parameterType;
    }

    @Override
    public Class<?> getTargetClass() {
        return this.targetClass;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public Class<?> getParameterType() {
        return this.parameterType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TargetSetterName)) {
            return false;
        }
        TargetSetterName that = (TargetSetterName)o;
        if (!Objects.equals(this.targetClass, that.targetClass)) {
            return false;
        }
        if (!Objects.equals(this.methodName, that.methodName)) {
            return false;
        }
        return Objects.equals(this.parameterType, that.parameterType);
    }

    public int hashCode() {
        int result = this.targetClass != null ? this.targetClass.hashCode() : 0;
        result = 31 * result + (this.methodName != null ? this.methodName.hashCode() : 0);
        result = 31 * result + (this.parameterType != null ? this.parameterType.hashCode() : 0);
        return result;
    }

    public String toString() {
        String s = "setter(";
        if (this.targetClass != null) {
            s = s + this.targetClass.getSimpleName() + ", ";
        }
        s = s + '\"' + this.methodName;
        if (this.parameterType != null) {
            s = s + '(' + this.parameterType.getSimpleName() + ')';
        }
        return s + "\")";
    }
}

