/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.selectors;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.instancio.GroupableSelector;
import org.instancio.Scope;
import org.instancio.ScopeableSelector;
import org.instancio.Selector;
import org.instancio.internal.ApiValidator;
import org.instancio.internal.selectors.BaseSelector;
import org.instancio.internal.selectors.PrimitiveAndWrapperSelectorImpl;
import org.instancio.internal.selectors.ScopeImpl;
import org.instancio.internal.selectors.Target;
import org.instancio.internal.selectors.TargetRoot;
import org.instancio.internal.util.Format;
import org.instancio.internal.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SelectorImpl
extends BaseSelector
implements Selector,
GroupableSelector {
    private static final SelectorImpl ROOT_SELECTOR = SelectorImpl.builder().target(TargetRoot.INSTANCE).depth(0).build();
    private final Target target;
    private final Selector parent;
    private final Integer depth;
    private int hash;

    private SelectorImpl(Target target, @NotNull List<Scope> scopes, @Nullable Selector parent, @NotNull Throwable stackTraceHolder, @Nullable Integer depth, boolean isLenient) {
        super(scopes, stackTraceHolder, isLenient, false);
        this.target = target;
        this.parent = parent;
        this.depth = depth;
    }

    private SelectorImpl(Builder builder) {
        this(builder.target, ObjectUtils.defaultIfNull(builder.scopes, Collections.emptyList()), builder.parent, ObjectUtils.defaultIfNull(builder.stackTraceHolder, Throwable::new), builder.depth, builder.isLenient);
    }

    public static SelectorImpl getRootSelector() {
        return ROOT_SELECTOR;
    }

    public Target getTarget() {
        return this.target;
    }

    @Override
    public Selector atDepth(int depth) {
        return this.toBuilder().depth(ApiValidator.validateDepth(depth)).build();
    }

    @Override
    public ScopeableSelector lenient() {
        return this.toBuilder().lenient().build();
    }

    @Override
    public Selector within(Scope ... scopes) {
        return this.toBuilder().scopes(Arrays.asList(scopes)).build();
    }

    @Override
    public Scope toScope() {
        return new ScopeImpl(this.target, this.depth);
    }

    public Selector getParent() {
        return this.parent;
    }

    public Class<?> getTargetClass() {
        return this.target.getTargetClass();
    }

    public Integer getDepth() {
        return this.depth;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SelectorImpl)) {
            return false;
        }
        SelectorImpl that = (SelectorImpl)o;
        return Objects.equals(this.getTarget(), that.getTarget()) && Objects.equals(this.getScopes(), that.getScopes()) && Objects.equals(this.getDepth(), that.getDepth());
    }

    public int hashCode() {
        if (this.hash == 0) {
            this.hash = this.computeHashCode();
        }
        return this.hash;
    }

    private int computeHashCode() {
        int result = this.getTarget().hashCode();
        result = 31 * result + this.getScopes().hashCode();
        result = 31 * result + (this.getDepth() == null ? 0 : this.getDepth().hashCode());
        return result;
    }

    public String toString() {
        if (this.parent instanceof PrimitiveAndWrapperSelectorImpl) {
            return this.parent.toString();
        }
        if (this.target instanceof TargetRoot) {
            return "root()";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.target);
        if (this.depth != null) {
            sb.append(".atDepth(").append(this.depth).append(')');
        }
        if (!this.getScopes().isEmpty()) {
            sb.append(".within(").append(Format.formatScopes(this.getScopes())).append(')');
        }
        if (this.isLenient()) {
            sb.append(".lenient()");
        }
        return sb.toString();
    }

    public Builder toBuilder() {
        Builder builder = new Builder();
        builder.target = this.target;
        builder.scopes = this.getScopes();
        builder.parent = this.parent;
        builder.stackTraceHolder = this.getStackTraceHolder();
        builder.depth = this.depth;
        builder.isLenient = this.isLenient();
        return builder;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Target target;
        private List<Scope> scopes;
        private Selector parent;
        private Throwable stackTraceHolder;
        private Integer depth;
        private boolean isLenient;

        private Builder() {
        }

        public Builder target(Target target) {
            this.target = target;
            return this;
        }

        public Builder scopes(List<Scope> scopes) {
            this.scopes = scopes;
            return this;
        }

        public Builder parent(Selector parent) {
            this.parent = parent;
            return this;
        }

        public Builder stackTraceHolder(Throwable stackTraceHolder) {
            this.stackTraceHolder = stackTraceHolder;
            return this;
        }

        public Builder depth(Integer depth) {
            this.depth = depth;
            return this;
        }

        public Builder lenient() {
            this.isLenient = true;
            return this;
        }

        public SelectorImpl build() {
            return new SelectorImpl(this);
        }
    }
}

