/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.nodes;

import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.instancio.internal.util.ObjectUtils;
import org.instancio.internal.util.TypeUtils;

public final class TypeMap {
    private final Map<TypeVariable<?>, Type> rootTypeMap;
    private final Map<Type, Type> typeVariableMap;

    TypeMap(Type genericType, Map<TypeVariable<?>, Type> rootTypeMap, Map<Type, Type> subtypeMappingTypeMap, TypeMap copyFrom) {
        this.rootTypeMap = new HashMap(copyFrom.rootTypeMap);
        this.rootTypeMap.putAll(rootTypeMap);
        this.typeVariableMap = new HashMap<Type, Type>(copyFrom.typeVariableMap);
        this.typeVariableMap.putAll(this.buildTypeMap(genericType, subtypeMappingTypeMap));
    }

    TypeMap(Type genericType, Map<TypeVariable<?>, Type> rootTypeMap, Map<Type, Type> subtypeMappingTypeMap) {
        this.rootTypeMap = Collections.unmodifiableMap(rootTypeMap);
        this.typeVariableMap = Collections.unmodifiableMap(this.buildTypeMap(genericType, subtypeMappingTypeMap));
    }

    public Type get(Type type) {
        return this.typeVariableMap.get(type);
    }

    public Type getOrDefault(Type type, Type defaultValue) {
        return this.typeVariableMap.getOrDefault(type, defaultValue);
    }

    public int size() {
        return this.typeVariableMap.size();
    }

    private Map<Type, Type> buildTypeMap(Type type, Map<Type, Type> subtypeMappingTypeMap) {
        HashMap<Type, Type> map = new HashMap<Type, Type>(subtypeMappingTypeMap);
        if (type instanceof Class) {
            return map;
        }
        if (type instanceof TypeVariable && this.rootTypeMap.containsKey(type)) {
            Type mappedType = this.rootTypeMap.get(type);
            map.put(type, mappedType);
            return map;
        }
        if (type instanceof ParameterizedType) {
            Class rawType = TypeUtils.getRawType(type);
            Type[] typeArgs = ((ParameterizedType)type).getActualTypeArguments();
            TypeVariable<Class<T>>[] typeVars = rawType.getTypeParameters();
            for (int i = 0; i < typeArgs.length; ++i) {
                Type mappedType = this.resolveTypeMapping(typeArgs[i]);
                map.put(typeVars[i], ObjectUtils.defaultIfNull(mappedType, typeArgs[i]));
            }
        }
        return map;
    }

    private Type resolveTypeMapping(Type type) {
        if (type instanceof Class || type instanceof ParameterizedType || type instanceof GenericArrayType) {
            return type;
        }
        if (type instanceof TypeVariable) {
            return this.rootTypeMap.get(type);
        }
        if (type instanceof WildcardType) {
            WildcardType wType = (WildcardType)type;
            return this.resolveTypeMapping(wType.getUpperBounds()[0]);
        }
        throw new UnsupportedOperationException("Unsupported type: " + type.getClass());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TypeMap)) {
            return false;
        }
        TypeMap other = (TypeMap)o;
        return Objects.equals(this.rootTypeMap, other.rootTypeMap) && Objects.equals(this.typeVariableMap, other.typeVariableMap);
    }

    public int hashCode() {
        int result = this.rootTypeMap != null ? this.rootTypeMap.hashCode() : 0;
        result = 31 * result + (this.typeVariableMap != null ? this.typeVariableMap.hashCode() : 0);
        return result;
    }
}

