/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.generator.util;

import java.util.Collection;
import org.instancio.Random;
import org.instancio.generator.GeneratorContext;
import org.instancio.generator.specs.OneOfCollectionSpec;
import org.instancio.internal.ApiValidator;
import org.instancio.internal.generator.AbstractGenerator;
import org.instancio.support.Global;

public class OneOfCollectionGenerator<T>
extends AbstractGenerator<T>
implements OneOfCollectionSpec<T> {
    private Collection<T> values;

    public OneOfCollectionGenerator() {
        this(Global.generatorContext());
    }

    public OneOfCollectionGenerator(GeneratorContext context) {
        super(context);
    }

    @Override
    public String apiMethod() {
        return "oneOf()";
    }

    @Override
    public OneOfCollectionGenerator<T> oneOf(Collection<T> values) {
        this.values = ApiValidator.notEmpty(values, "Collection must have at least one element", new Object[0]);
        return this;
    }

    @Override
    public OneOfCollectionGenerator<T> nullable() {
        super.nullable();
        return this;
    }

    @Override
    public T tryGenerateNonNull(Random random) {
        return random.oneOf(this.values);
    }
}

