/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.generator.util;

import java.util.Date;
import org.instancio.Random;
import org.instancio.generator.GeneratorContext;
import org.instancio.generator.specs.TemporalGeneratorSpec;
import org.instancio.internal.generator.AbstractGenerator;
import org.instancio.internal.generator.time.InstantGenerator;

public class DateGenerator
extends AbstractGenerator<Date>
implements TemporalGeneratorSpec<Date> {
    private final InstantGenerator delegate;

    public DateGenerator(GeneratorContext context) {
        super(context);
        this.delegate = new InstantGenerator(context);
    }

    @Override
    public String apiMethod() {
        return "date()";
    }

    public DateGenerator past() {
        this.delegate.past();
        return this;
    }

    public DateGenerator future() {
        this.delegate.future();
        return this;
    }

    public DateGenerator min(Date min) {
        this.delegate.min(min.toInstant());
        return this;
    }

    public DateGenerator max(Date max) {
        this.delegate.max(max.toInstant());
        return this;
    }

    public DateGenerator range(Date min, Date max) {
        this.delegate.range(min.toInstant(), max.toInstant());
        return this;
    }

    @Override
    public DateGenerator nullable() {
        super.nullable();
        return this;
    }

    @Override
    protected Date tryGenerateNonNull(Random random) {
        return Date.from(this.delegate.tryGenerateNonNull(random));
    }
}

