/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.generator.time;

import java.time.Period;
import org.instancio.Random;
import org.instancio.generator.GeneratorContext;
import org.instancio.generator.specs.PeriodSpec;
import org.instancio.internal.ApiValidator;
import org.instancio.internal.generator.AbstractGenerator;
import org.instancio.support.Global;

public class PeriodGenerator
extends AbstractGenerator<Period>
implements PeriodSpec {
    private static final int DEFAULT_MIN_DAYS = 1;
    private static final int DEFAULT_MAX_DAYS = 365;
    private int minDays = 1;
    private int maxDays = 365;
    private int minMonths;
    private int maxMonths;
    private int minYears;
    private int maxYears;

    public PeriodGenerator() {
        this(Global.generatorContext());
    }

    public PeriodGenerator(GeneratorContext context) {
        super(context);
    }

    @Override
    public String apiMethod() {
        return "period()";
    }

    @Override
    public PeriodGenerator days(int min, int max) {
        ApiValidator.isTrue(min <= max, "Period days 'min' must be less than or equal 'max': days(%s, %s)", min, max);
        this.minDays = min;
        this.maxDays = max;
        return this;
    }

    @Override
    public PeriodGenerator months(int min, int max) {
        ApiValidator.isTrue(min <= max, "Period months 'min' must be less than or equal 'max': months(%s, %s)", min, max);
        this.minMonths = min;
        this.maxMonths = max;
        return this;
    }

    @Override
    public PeriodGenerator years(int min, int max) {
        ApiValidator.isTrue(min <= max, "Period years 'min' must be less than or equal 'max': years(%s, %s)", min, max);
        this.minYears = min;
        this.maxYears = max;
        return this;
    }

    @Override
    public PeriodGenerator nullable() {
        super.nullable();
        return this;
    }

    @Override
    protected Period tryGenerateNonNull(Random random) {
        return Period.of(random.intRange(this.minYears, this.maxYears), random.intRange(this.minMonths, this.maxMonths), random.intRange(this.minDays, this.maxDays));
    }
}

