/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.generator.domain.id.pol;

import java.time.LocalDate;
import java.util.List;
import org.instancio.Random;
import org.instancio.generator.Generator;
import org.instancio.generator.GeneratorContext;
import org.instancio.generator.specs.pol.PeselSpec;
import org.instancio.internal.generator.domain.id.pol.PeselDateGenerator;
import org.instancio.internal.generator.domain.id.pol.WeightsModCheckGenerator;
import org.instancio.internal.util.CollectionUtils;
import org.instancio.internal.util.NumberUtils;
import org.instancio.support.Global;

public class PeselGenerator
extends WeightsModCheckGenerator
implements PeselSpec {
    private static final List<Integer> PESEL_WEIGHTS = CollectionUtils.asUnmodifiableList(1, 3, 7, 9, 1, 3, 7, 9, 1, 3);
    private static final int GENDER_DIGIT_POSITION = 9;
    private final PeselDateGenerator peselDateGenerator;
    private Gender gender;

    public PeselGenerator() {
        this(Global.generatorContext());
    }

    public PeselGenerator(GeneratorContext context) {
        super(context);
        this.peselDateGenerator = new PeselDateGenerator(context);
    }

    @Override
    public String apiMethod() {
        return "pesel()";
    }

    @Override
    protected String payload(Random random) {
        String birthdate = this.peselDateGenerator.tryGenerateNonNull(random);
        String serialNumber = random.digits(this.payloadLength() - birthdate.length());
        Gender selectedGender = this.gender == null ? random.oneOf(Gender.values()) : this.gender;
        StringBuilder payload = new StringBuilder(birthdate).append(serialNumber);
        payload.setCharAt(9, ((Character)random.oneOf(selectedGender.digits)).charValue());
        return payload.toString();
    }

    @Override
    protected char getCheckDigit(String payload) {
        int modulo = this.modulo(payload);
        if (modulo == 0) {
            return '0';
        }
        return NumberUtils.toDigitChar(this.base() - modulo);
    }

    @Override
    public PeselGenerator birthdate(Generator<LocalDate> localDateGenerator) {
        this.peselDateGenerator.withLocalDate(localDateGenerator);
        return this;
    }

    @Override
    public PeselGenerator male() {
        this.gender = Gender.MALE;
        return this;
    }

    @Override
    public PeselGenerator female() {
        this.gender = Gender.FEMALE;
        return this;
    }

    @Override
    public PeselGenerator nullable() {
        super.nullable();
        return this;
    }

    @Override
    protected List<Integer> weights() {
        return PESEL_WEIGHTS;
    }

    @Override
    protected int base() {
        return 10;
    }

    private static enum Gender {
        MALE(Character.valueOf('1'), Character.valueOf('3'), Character.valueOf('5'), Character.valueOf('7'), Character.valueOf('9')),
        FEMALE(Character.valueOf('0'), Character.valueOf('2'), Character.valueOf('4'), Character.valueOf('6'), Character.valueOf('8'));

        private final List<Character> digits;

        private Gender(Character ... digits) {
            this.digits = CollectionUtils.asUnmodifiableList(digits);
        }
    }
}

