/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.generator;

import org.instancio.Random;
import org.instancio.documentation.InternalApi;
import org.instancio.generator.Generator;
import org.instancio.generator.GeneratorContext;
import org.instancio.generator.Hints;
import org.instancio.generator.specs.NullableGeneratorSpec;
import org.instancio.internal.util.Constants;

@InternalApi
public abstract class AbstractGenerator<T>
implements Generator<T>,
NullableGeneratorSpec<T> {
    private final GeneratorContext context;
    private boolean nullable;
    private boolean isDelegating;

    protected AbstractGenerator(GeneratorContext context) {
        this.context = context;
    }

    public abstract String apiMethod();

    protected abstract T tryGenerateNonNull(Random var1);

    @Override
    public T generate(Random random) {
        return random.diceRoll(this.isNullable()) ? null : (T)this.tryGenerateNonNull(random);
    }

    @Override
    public NullableGeneratorSpec<T> nullable() {
        this.nullable = true;
        return this;
    }

    public NullableGeneratorSpec<T> nullable(boolean isNullable) {
        this.nullable = isNullable;
        return this;
    }

    public final boolean isNullable() {
        return this.nullable;
    }

    protected final void setDelegating(boolean delegating) {
        this.isDelegating = delegating;
    }

    public final boolean isDelegating() {
        return this.isDelegating;
    }

    public GeneratorContext getContext() {
        return this.context;
    }

    @Override
    public Hints hints() {
        return Constants.DO_NOT_MODIFY_HINT;
    }
}

