/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.context;

import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.instancio.Assignment;
import org.instancio.FilterPredicate;
import org.instancio.GeneratorSpecProvider;
import org.instancio.Model;
import org.instancio.OnCompleteCallback;
import org.instancio.Random;
import org.instancio.Scope;
import org.instancio.Select;
import org.instancio.TargetSelector;
import org.instancio.generator.Generator;
import org.instancio.generator.GeneratorContext;
import org.instancio.internal.ApiMethodSelector;
import org.instancio.internal.ApiValidator;
import org.instancio.internal.Flattener;
import org.instancio.internal.InternalModel;
import org.instancio.internal.RandomHelper;
import org.instancio.internal.assignment.InternalAssignment;
import org.instancio.internal.context.BooleanSelectorMap;
import org.instancio.internal.context.ModelContextHelper;
import org.instancio.internal.context.ModelContextSelectorMap;
import org.instancio.internal.context.ModelContextSource;
import org.instancio.internal.context.SelectorMap;
import org.instancio.internal.context.SelectorMaps;
import org.instancio.internal.context.SelectorNodeMatchesCollector;
import org.instancio.internal.context.SubtypeSelectorMap;
import org.instancio.internal.context.UnusedEmitItemsReporter;
import org.instancio.internal.context.UnusedSelectorReporter;
import org.instancio.internal.generator.misc.GeneratorDecorator;
import org.instancio.internal.nodes.InternalNode;
import org.instancio.internal.selectors.BlankSelectors;
import org.instancio.internal.selectors.InternalSelector;
import org.instancio.internal.selectors.SelectorProcessor;
import org.instancio.internal.selectors.SetterSelectorHolder;
import org.instancio.internal.spi.InternalServiceProvider;
import org.instancio.internal.spi.InternalServiceProviderContext;
import org.instancio.internal.spi.InternalServiceProviderImpl;
import org.instancio.internal.spi.Providers;
import org.instancio.internal.util.CollectionUtils;
import org.instancio.internal.util.ErrorMessageUtils;
import org.instancio.internal.util.Fail;
import org.instancio.internal.util.ObjectUtils;
import org.instancio.internal.util.ServiceLoaders;
import org.instancio.internal.util.SystemProperties;
import org.instancio.internal.util.TypeUtils;
import org.instancio.internal.util.Verify;
import org.instancio.settings.AssignmentType;
import org.instancio.settings.Keys;
import org.instancio.settings.Mode;
import org.instancio.settings.SettingKey;
import org.instancio.settings.Settings;
import org.instancio.support.Global;
import org.instancio.support.ThreadLocalSettings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ModelContext<T> {
    private static final Logger LOG = LoggerFactory.getLogger(ModelContext.class);
    private static final List<InternalServiceProvider> INTERNAL_SERVICE_PROVIDERS = CollectionUtils.combine(ServiceLoaders.loadAll(InternalServiceProvider.class), new InternalServiceProviderImpl());
    private final Providers providers;
    private final Type rootType;
    private final List<Type> rootTypeParameters;
    private final Map<TypeVariable<?>, Type> rootTypeMap;
    private final Integer maxDepth;
    private final Long seed;
    private final Random random;
    private final Settings settings;
    private final ModelContextSource contextSource;
    private final SelectorMaps selectorMaps;
    private final boolean verbose;

    private ModelContext(Builder<T> builder) {
        this.contextSource = ((Builder)builder).getModelContextSource();
        this.rootType = ((Builder)builder).rootType;
        this.rootTypeParameters = this.contextSource.getWithTypeParametersList();
        this.rootTypeMap = Collections.unmodifiableMap(ModelContextHelper.buildRootTypeMap(((Builder)builder).rootType, this.rootTypeParameters));
        this.seed = ((Builder)builder).seed;
        this.maxDepth = ((Builder)builder).maxDepth;
        this.verbose = ((Builder)builder).verbose;
        this.settings = ModelContext.createSettings(builder);
        this.random = RandomHelper.resolveRandom(this.settings.get(Keys.SEED), ((Builder)builder).seed);
        this.selectorMaps = new SelectorMaps(new GeneratorContext(this.settings, this.random));
        this.selectorMaps.initSelectorMaps(this.contextSource);
        this.providers = new Providers(new InternalServiceProviderContext(this.settings, this.random));
    }

    private static Settings createSettings(Builder<?> builder) {
        AssignmentType assignmentTypeOverride;
        Settings settings = Global.getPropertiesFileSettings().merge(ThreadLocalSettings.getInstance().get()).merge(((Builder)builder).settings);
        if (Boolean.TRUE.equals(((Builder)builder).lenient)) {
            settings.set(Keys.MODE, Mode.LENIENT);
        }
        if ((assignmentTypeOverride = SystemProperties.getAssignmentType()) != null) {
            settings.set(Keys.ASSIGNMENT_TYPE, assignmentTypeOverride);
        }
        LOG.trace("Resolved settings: {}", (Object)settings);
        SetterSelectorHolder holder = ((Builder)builder).getSetMethodSelectorHolder();
        ApiValidator.failIfMethodSelectorIsUsedWithFieldAssignment(settings.get(Keys.ASSIGNMENT_TYPE), holder.getSetterSelector());
        return settings.lock();
    }

    public List<InternalServiceProvider> getInternalServiceProviders() {
        return INTERNAL_SERVICE_PROVIDERS;
    }

    public Providers getServiceProviders() {
        return this.providers;
    }

    public void reportWarnings() {
        this.reportUnusedSelectorWarnings();
        this.reportEmitGeneratorWarnings();
    }

    private void reportEmitGeneratorWarnings() {
        SelectorMap<Generator<?>> selectorMap = this.selectorMaps.getGeneratorSelectorMap().getSelectorMap();
        UnusedEmitItemsReporter reporter = new UnusedEmitItemsReporter(selectorMap);
        reporter.report();
    }

    void reportUnusedSelectorWarnings() {
        if (this.settings.get(Keys.MODE) == Mode.STRICT && !this.selectorMaps.allEmpty()) {
            new UnusedSelectorReporter(this.getMaxDepth(), this.selectorMaps).report();
        }
    }

    public Map<ApiMethodSelector, Map<TargetSelector, Set<InternalNode>>> getSelectors(InternalNode rootNode) {
        return new SelectorNodeMatchesCollector(this.selectorMaps).getNodeMatches(rootNode);
    }

    public Type getRootType() {
        return this.rootType;
    }

    public Map<TypeVariable<?>, Type> getRootTypeMap() {
        return this.rootTypeMap;
    }

    public Settings getSettings() {
        return this.settings;
    }

    public Random getRandom() {
        return this.random;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public Integer getMaxDepth() {
        return ObjectUtils.defaultIfNull(this.maxDepth, this.settings.get(Keys.MAX_DEPTH));
    }

    public SelectorMaps getSelectorMaps() {
        return this.selectorMaps;
    }

    public boolean isIgnored(InternalNode node) {
        return this.selectorMaps.getIgnoreSelectorMap().isTrue(node);
    }

    public boolean isNullable(InternalNode node) {
        return this.selectorMaps.getWithNullableSelectorMap().isTrue(node);
    }

    public boolean isAccepted(InternalNode node, Object value) {
        Predicate<Object> predicate = this.selectorMaps.getFilterSelectorMap().getPredicate(node);
        if (predicate == null) {
            return true;
        }
        try {
            return predicate.test(value);
        }
        catch (Exception ex) {
            throw Fail.withUsageError(ErrorMessageUtils.filterPredicateErrorMessage(value, node, ex), new Object[0]);
        }
    }

    public Optional<Generator<?>> getGenerator(InternalNode node) {
        return this.selectorMaps.getGeneratorSelectorMap().getGenerator(node);
    }

    public List<OnCompleteCallback<?>> getCallbacks(InternalNode node) {
        return this.selectorMaps.getOnCompleteSelectorMap().getCallbacks(node);
    }

    public BooleanSelectorMap getIgnoreSelectorMap() {
        return this.selectorMaps.getIgnoreSelectorMap();
    }

    public SubtypeSelectorMap getSubtypeSelectorMap() {
        return this.selectorMaps.getSubtypeSelectorMap();
    }

    public ModelContextSelectorMap getSetModelSelectorMap() {
        return this.selectorMaps.getSetModelSelectorMap();
    }

    public List<InternalAssignment> getAssignments(InternalNode node) {
        return this.selectorMaps.getAssignmentSelectorMap().getAssignments(node);
    }

    public BooleanSelectorMap getAssignmentOriginSelectorMap() {
        return this.selectorMaps.getAssignmentSelectorMap().getOriginSelectors();
    }

    public List<TargetSelector> getAssignmentDestinationSelectors(InternalNode node) {
        return this.selectorMaps.getAssignmentSelectorMap().getDestinationSelectors(node);
    }

    ModelContextSource getContextSource() {
        return this.contextSource;
    }

    public Builder<T> toBuilder() {
        Builder builder = new Builder(this.rootType);
        builder.maxDepth = this.maxDepth;
        builder.seed = this.seed;
        builder.settings = this.settings;
        builder.withTypeParametersList = new ArrayList<Type>(this.rootTypeParameters);
        builder.withNullableSet = new LinkedHashSet<TargetSelector>(this.contextSource.getWithNullableSet());
        builder.ignoreSet = new LinkedHashSet<TargetSelector>(this.contextSource.getIgnoreSet());
        builder.generatorMap = new LinkedHashMap(this.contextSource.getGeneratorMap());
        builder.generatorSpecMap = new LinkedHashMap(this.contextSource.getGeneratorSpecMap());
        builder.subtypeMap = new LinkedHashMap(this.contextSource.getSubtypeMap());
        builder.onCompleteMap = new LinkedHashMap(this.contextSource.getOnCompleteMap());
        builder.filterMap = new LinkedHashMap(this.contextSource.getFilterMap());
        builder.assignmentMap = new LinkedHashMap<TargetSelector, List<Assignment>>(this.contextSource.getAssignmentMap());
        builder.setModelMap = new LinkedHashMap(this.contextSource.getSetModelMap());
        return builder;
    }

    public static <T> Builder<T> builder(Type rootType) {
        return new Builder(rootType);
    }

    public static final class Builder<T> {
        private final Type rootType;
        private List<Type> withTypeParametersList;
        private Map<TargetSelector, Class<?>> subtypeMap;
        private Map<TargetSelector, GeneratorSpecProvider<?>> generatorSpecMap;
        private Map<TargetSelector, Generator<?>> generatorMap;
        private Map<TargetSelector, OnCompleteCallback<?>> onCompleteMap;
        private Map<TargetSelector, Predicate<?>> filterMap;
        private Map<TargetSelector, List<Assignment>> assignmentMap;
        private Map<TargetSelector, ModelContext<?>> setModelMap;
        private Set<TargetSelector> ignoreSet;
        private Set<TargetSelector> withNullableSet;
        private Settings settings;
        private Integer maxDepth;
        private Long seed;
        private Boolean lenient;
        private boolean verbose;
        private final SelectorProcessor selectorProcessor;
        private final SetterSelectorHolder setMethodSelectorHolder = new SetterSelectorHolder();

        private Builder(Type rootType) {
            ApiValidator.validateRootClass(rootType);
            this.rootType = rootType;
            this.selectorProcessor = new SelectorProcessor(TypeUtils.getRawType(rootType), INTERNAL_SERVICE_PROVIDERS, this.setMethodSelectorHolder);
        }

        private SetterSelectorHolder getSetMethodSelectorHolder() {
            return this.setMethodSelectorHolder;
        }

        public Builder<T> withRootTypeParameters(List<Type> rootTypeParameters) {
            ApiValidator.validateTypeParameters(this.rootType, rootTypeParameters);
            this.withTypeParametersList = new ArrayList<Type>(rootTypeParameters);
            return this;
        }

        private <V> Builder<T> addSelector(Map<TargetSelector, V> map, TargetSelector selector, V value) {
            List<TargetSelector> processed = this.selectorProcessor.process(selector);
            for (TargetSelector s : processed) {
                map.put(s, value);
            }
            return this;
        }

        public Builder<T> withSubtype(TargetSelector selector, Class<?> subtype) {
            ApiValidator.notNull(subtype, "subtype must not be null");
            this.subtypeMap = CollectionUtils.newLinkedHashMapIfNull(this.subtypeMap);
            return this.addSelector(this.subtypeMap, selector, subtype);
        }

        public Builder<T> withGenerator(TargetSelector selector, Generator<?> generator) {
            ApiValidator.validateGeneratorNotNull(generator);
            this.generatorMap = CollectionUtils.newLinkedHashMapIfNull(this.generatorMap);
            return this.addSelector(this.generatorMap, selector, generator);
        }

        public Builder<T> withSupplier(TargetSelector selector, Supplier<?> supplier) {
            ApiValidator.validateSupplierNotNull(supplier);
            return this.withGenerator(selector, GeneratorDecorator.decorate(supplier));
        }

        public <V> Builder<T> withGeneratorSpec(TargetSelector selector, GeneratorSpecProvider<V> spec) {
            ApiValidator.validateGenerateSecondArgument(spec);
            this.generatorSpecMap = CollectionUtils.newLinkedHashMapIfNull(this.generatorSpecMap);
            return this.addSelector(this.generatorSpecMap, selector, spec);
        }

        public Builder<T> withOnCompleteCallback(TargetSelector selector, OnCompleteCallback<?> callback) {
            this.onCompleteMap = CollectionUtils.newLinkedHashMapIfNull(this.onCompleteMap);
            return this.addSelector(this.onCompleteMap, selector, callback);
        }

        public Builder<T> filter(TargetSelector selector, Predicate<?> predicate) {
            ApiValidator.notNull(predicate, "predicate must not be null");
            this.filterMap = CollectionUtils.newLinkedHashMapIfNull(this.filterMap);
            return this.addSelector(this.filterMap, selector, predicate);
        }

        public Builder<T> withUnique(TargetSelector selector) {
            return this.filter(selector, new FilterPredicate<Object>(){
                final Set<Object> generatedValues = new HashSet<Object>();

                @Override
                public boolean test(Object obj) {
                    return this.generatedValues.add(obj);
                }
            });
        }

        public Builder<T> withIgnored(TargetSelector selector) {
            this.ignoreSet = CollectionUtils.newLinkedHashSetIfNull(this.ignoreSet);
            this.ignoreSet.addAll(this.selectorProcessor.process(selector));
            return this;
        }

        public Builder<T> withNullable(TargetSelector selector) {
            this.withNullableSet = CollectionUtils.newLinkedHashSetIfNull(this.withNullableSet);
            this.withNullableSet.addAll(this.selectorProcessor.process(selector));
            return this;
        }

        public Builder<T> withMaxDepth(int maxDepth) {
            ApiValidator.isTrue(maxDepth >= 0, "Maximum depth must not be negative: %s", maxDepth);
            this.maxDepth = maxDepth;
            return this;
        }

        public Builder<T> withAssignments(Assignment ... assignments) {
            ApiValidator.notNull(assignments, "assignments array must not be null");
            this.assignmentMap = CollectionUtils.newLinkedHashMapIfNull(this.assignmentMap);
            for (Assignment assignment : assignments) {
                ApiValidator.notNull(assignment, "assignments array must not contain null");
                this.processAssignment(assignment);
            }
            return this;
        }

        private void processAssignment(Assignment assignment) {
            List assignments = ((Flattener)((Object)assignment)).flatten();
            for (InternalAssignment a : assignments) {
                List<TargetSelector> origin = this.selectorProcessor.process(a.getOrigin());
                List<TargetSelector> destinations = this.selectorProcessor.process(a.getDestination());
                Verify.isTrue(origin.size() == 1, "Origin has multiple selectors", new Object[0]);
                for (TargetSelector destination : destinations) {
                    InternalAssignment processedAssignment = a.toBuilder().origin(origin.get(0)).destination(destination).build();
                    this.assignmentMap.computeIfAbsent(destination, k -> new ArrayList()).add(processedAssignment);
                }
            }
        }

        public <V> Builder<T> withSetting(SettingKey<V> key, V value) {
            if (this.settings == null) {
                this.settings = Settings.create();
            } else if (this.settings.isLocked()) {
                this.settings = Settings.from(this.settings);
            }
            this.settings.set(key, value);
            return this;
        }

        public Builder<T> withSettings(Settings arg) {
            ApiValidator.notNull(arg, "Null Settings provided to withSettings() method");
            this.settings = this.settings == null ? Settings.from(arg) : this.settings.merge(arg);
            return this;
        }

        public Builder<T> withSeed(long seed) {
            this.seed = seed;
            return this;
        }

        public Builder<T> setBlank(TargetSelector selector) {
            if (Objects.equals(selector, Select.root())) {
                this.setBlankTargets(new Scope[0]);
            } else {
                List<TargetSelector> processedSelectors = this.selectorProcessor.process(selector);
                for (TargetSelector processedSelector : processedSelectors) {
                    InternalSelector target = (InternalSelector)processedSelector;
                    Scope[] effectiveScopes = CollectionUtils.combine(target.getScopes(), target.toScope()).toArray(new Scope[0]);
                    this.setBlankTargets(effectiveScopes);
                }
            }
            return this;
        }

        private void setBlankTargets(Scope ... scopes) {
            this.withSupplier(BlankSelectors.leafSelector().within(scopes), () -> null);
            this.withGeneratorSpec(BlankSelectors.collectionSelector().within(scopes).lenient(), gen -> gen.collection().size(0));
            this.withGeneratorSpec(BlankSelectors.mapSelector().within(scopes).lenient(), gen -> gen.map().size(0));
            this.withGeneratorSpec(BlankSelectors.arraySelector().within(scopes).lenient(), gen -> gen.array().length(0));
        }

        public Builder<T> lenient() {
            this.lenient = true;
            return this;
        }

        public Builder<T> verbose() {
            this.verbose = true;
            return this;
        }

        public Builder<T> useModelAsTypeArgument(ModelContext<?> otherContext) {
            this.seed = ((ModelContext)otherContext).seed;
            this.withTypeParametersList = Collections.singletonList(otherContext.getRootType());
            ModelContextSource src = ((ModelContext)otherContext).contextSource;
            this.withNullableSet = new LinkedHashSet<TargetSelector>(src.getWithNullableSet());
            this.ignoreSet = new LinkedHashSet<TargetSelector>(src.getIgnoreSet());
            this.generatorMap = new LinkedHashMap(src.getGeneratorMap());
            this.generatorSpecMap = new LinkedHashMap(src.getGeneratorSpecMap());
            this.subtypeMap = new LinkedHashMap(src.getSubtypeMap());
            this.onCompleteMap = new LinkedHashMap(src.getOnCompleteMap());
            this.filterMap = new LinkedHashMap(src.getFilterMap());
            this.assignmentMap = new LinkedHashMap<TargetSelector, List<Assignment>>(src.getAssignmentMap());
            this.setModelMap = new LinkedHashMap(src.getSetModelMap());
            this.maxDepth = ((ModelContext)otherContext).maxDepth == null ? null : Integer.valueOf(((ModelContext)otherContext).maxDepth + 1);
            this.settings = Settings.from(((ModelContext)otherContext).settings).set(Keys.MAX_DEPTH, ((ModelContext)otherContext).settings.get(Keys.MAX_DEPTH) + 1).lock();
            return this;
        }

        public Builder<T> withModel(TargetSelector modelSelector, Model<?> model) {
            this.setModelMap = CollectionUtils.newLinkedHashMapIfNull(this.setModelMap);
            ModelContext otherCtx = ((InternalModel)model).getModelContext();
            List<TargetSelector> processedSelectors = this.selectorProcessor.process(modelSelector);
            for (TargetSelector modelTarget : processedSelectors) {
                this.setModelMap.put(modelTarget, otherCtx);
            }
            return this;
        }

        private ModelContextSource getModelContextSource() {
            return new ModelContextSource(this.withTypeParametersList, this.subtypeMap, this.generatorSpecMap, this.generatorMap, this.onCompleteMap, this.filterMap, this.assignmentMap, this.setModelMap, this.ignoreSet, this.withNullableSet);
        }

        public ModelContext<T> build() {
            return new ModelContext(this);
        }
    }
}

