/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.context;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.instancio.Assignment;
import org.instancio.TargetSelector;
import org.instancio.generator.Generator;
import org.instancio.generator.GeneratorContext;
import org.instancio.generators.Generators;
import org.instancio.internal.assignment.GeneratorHolder;
import org.instancio.internal.assignment.InternalAssignment;
import org.instancio.internal.context.BooleanSelectorMap;
import org.instancio.internal.context.GeneratorInitialiser;
import org.instancio.internal.context.SelectorMap;
import org.instancio.internal.context.SelectorMapImpl;
import org.instancio.internal.nodes.InternalNode;
import org.instancio.internal.util.CollectionUtils;
import org.jetbrains.annotations.NotNull;

final class AssignmentSelectorMap {
    private final GeneratorContext generatorContext;
    private final GeneratorInitialiser generatorInitialiser;
    private final SelectorMap<List<InternalAssignment>> destinationToAssignmentsMap = new SelectorMapImpl<List<InternalAssignment>>();
    private final SelectorMap<List<TargetSelector>> originToDestinationSelectorsMap = new SelectorMapImpl<List<TargetSelector>>();
    private final BooleanSelectorMap originSelectors = new BooleanSelectorMap();

    AssignmentSelectorMap(@NotNull GeneratorContext generatorContext) {
        this.generatorContext = generatorContext;
        this.generatorInitialiser = new GeneratorInitialiser(generatorContext);
    }

    void putAll(@NotNull Map<TargetSelector, List<Assignment>> targetSelectors) {
        for (Map.Entry<TargetSelector, List<Assignment>> entry : targetSelectors.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    void put(TargetSelector targetSelector, List<Assignment> assignments) {
        HashMap<TargetSelector, List> originDestinationsMap = new HashMap<TargetSelector, List>();
        List<InternalAssignment> processedAssignments = this.processAssignments(assignments);
        for (InternalAssignment internalAssignment : processedAssignments) {
            List destinations = originDestinationsMap.computeIfAbsent(internalAssignment.getOrigin(), k -> new ArrayList());
            destinations.add(internalAssignment.getDestination());
        }
        this.destinationToAssignmentsMap.put(targetSelector, processedAssignments);
        this.originSelectors.putAll(originDestinationsMap.keySet());
        for (Map.Entry entry : originDestinationsMap.entrySet()) {
            TargetSelector selector = (TargetSelector)entry.getKey();
            List destinations = (List)entry.getValue();
            List<List<TargetSelector>> currentDestinations = this.originToDestinationSelectorsMap.getValues(selector);
            if (currentDestinations.isEmpty()) {
                this.originToDestinationSelectorsMap.put(selector, destinations);
                continue;
            }
            currentDestinations.forEach(currentList -> currentList.addAll(destinations));
        }
    }

    private List<InternalAssignment> processAssignments(List<Assignment> assignments) {
        ArrayList<InternalAssignment> processed = new ArrayList<InternalAssignment>(assignments.size());
        Generators generators = new Generators(this.generatorContext);
        for (Assignment c : assignments) {
            InternalAssignment assignment = (InternalAssignment)c;
            if (assignment.getGeneratorHolder() != null) {
                GeneratorHolder holder = assignment.getGeneratorHolder();
                Generator generator = holder.getGenerator() == null ? (Generator)holder.getSpecProvider().getSpec(generators) : holder.getGenerator();
                Generator updatedGenerator = this.generatorInitialiser.initGenerator(assignment.getDestination(), generator);
                InternalAssignment updatedAssignment = assignment.toBuilder().generator(updatedGenerator).build();
                processed.add(updatedAssignment);
                continue;
            }
            processed.add(assignment);
        }
        return processed;
    }

    Map<TargetSelector, Class<?>> getSubtypeMap() {
        return Collections.unmodifiableMap(this.generatorInitialiser.getSubtypeMap());
    }

    List<InternalAssignment> getAssignments(InternalNode node) {
        Optional<List<InternalAssignment>> value = this.destinationToAssignmentsMap.getValue(node);
        return value.orElse(Collections.emptyList());
    }

    BooleanSelectorMap getOriginSelectors() {
        return this.originSelectors;
    }

    SelectorMap<List<InternalAssignment>> getDestinationToAssignmentsMap() {
        return this.destinationToAssignmentsMap;
    }

    SelectorMap<List<TargetSelector>> getOriginToDestinationSelectorsMap() {
        return this.originToDestinationSelectorsMap;
    }

    List<TargetSelector> getDestinationSelectors(InternalNode node) {
        List values = this.originToDestinationSelectorsMap.getValues(node);
        return CollectionUtils.flatMap(values);
    }
}

