/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.annotation;

import org.hibernate.validator.constraints.CreditCardNumber;
import org.hibernate.validator.constraints.EAN;
import org.hibernate.validator.constraints.Email;
import org.hibernate.validator.constraints.ISBN;
import org.hibernate.validator.constraints.LuhnCheck;
import org.hibernate.validator.constraints.Mod10Check;
import org.hibernate.validator.constraints.Mod11Check;
import org.hibernate.validator.constraints.URL;
import org.hibernate.validator.constraints.UUID;
import org.hibernate.validator.constraints.pl.NIP;
import org.hibernate.validator.constraints.pl.PESEL;
import org.hibernate.validator.constraints.pl.REGON;
import org.instancio.generator.GeneratorContext;
import org.instancio.internal.annotation.AbstractAnnotationConsumer;
import org.instancio.internal.annotation.AnnotationHandlerMap;
import org.instancio.internal.annotation.HibernateBeanValidationHandlerMap;
import org.instancio.internal.generator.checksum.LuhnGenerator;
import org.instancio.internal.generator.checksum.Mod10Generator;
import org.instancio.internal.generator.checksum.Mod11Generator;
import org.instancio.internal.generator.domain.finance.CreditCardNumberGenerator;
import org.instancio.internal.generator.domain.id.EanGenerator;
import org.instancio.internal.generator.domain.id.IsbnGenerator;
import org.instancio.internal.generator.domain.id.pol.NipGenerator;
import org.instancio.internal.generator.domain.id.pol.PeselGenerator;
import org.instancio.internal.generator.domain.id.pol.RegonGenerator;
import org.instancio.internal.generator.domain.internet.EmailGenerator;
import org.instancio.internal.generator.net.URLGenerator;
import org.instancio.internal.generator.util.UUIDGenerator;
import org.instancio.internal.util.StringUtils;
import org.jetbrains.annotations.NotNull;

final class HibernateBeanValidationAnnotationConsumer
extends AbstractAnnotationConsumer {
    HibernateBeanValidationAnnotationConsumer() {
        this.putPrimary(() -> EAN.class, (annotation, context) -> HibernateBeanValidationAnnotationConsumer.getEanGenerator((EAN)annotation, context));
        this.putPrimary(() -> Email.class, (annotation, context) -> new EmailGenerator(context));
        this.putPrimary(() -> LuhnCheck.class, (annotation, context) -> HibernateBeanValidationAnnotationConsumer.getLuhnGenerator((LuhnCheck)annotation, context));
        this.putPrimary(() -> Mod10Check.class, (annotation, context) -> HibernateBeanValidationAnnotationConsumer.getMod10Generator((Mod10Check)annotation, context));
        this.putPrimary(() -> Mod11Check.class, (annotation, context) -> HibernateBeanValidationAnnotationConsumer.getMod11Generator((Mod11Check)annotation, context));
        this.putPrimary(() -> CreditCardNumber.class, (annotation, context) -> new CreditCardNumberGenerator(context));
        this.putPrimary(() -> ISBN.class, (annotation, context) -> new IsbnGenerator(context));
        this.putPrimary(() -> UUID.class, (annotation, context) -> new UUIDGenerator(context));
        this.putPrimary(() -> URL.class, (annotation, context) -> HibernateBeanValidationAnnotationConsumer.getUrlGenerator((URL)annotation, context));
        this.putPrimary(() -> NIP.class, (annotation, context) -> new NipGenerator(context));
        this.putPrimary(() -> PESEL.class, (annotation, context) -> new PeselGenerator(context));
        this.putPrimary(() -> REGON.class, (annotation, context) -> new RegonGenerator(context));
    }

    @Override
    protected AnnotationHandlerMap getAnnotationHandlerMap() {
        return HibernateBeanValidationHandlerMap.getInstance();
    }

    private static URLGenerator getUrlGenerator(URL url, GeneratorContext context) {
        URLGenerator urlGenerator = new URLGenerator(context).port(url.port());
        if (!StringUtils.isBlank(url.protocol())) {
            urlGenerator.protocol(url.protocol());
        }
        if (!StringUtils.isBlank(url.host())) {
            urlGenerator.host(random -> url.host());
        }
        return urlGenerator;
    }

    @NotNull
    private static EanGenerator getEanGenerator(EAN ean, GeneratorContext context) {
        EanGenerator generator = new EanGenerator(context);
        if (ean.type() == EAN.Type.EAN8) {
            generator.type8();
        }
        return generator;
    }

    private static LuhnGenerator getLuhnGenerator(LuhnCheck luhn, GeneratorContext context) {
        LuhnGenerator generator = new LuhnGenerator(context).startIndex(luhn.startIndex()).endIndex(luhn.endIndex());
        if (luhn.checkDigitIndex() != -1) {
            generator.checkDigitIndex(luhn.checkDigitIndex());
        }
        return generator;
    }

    private static Mod10Generator getMod10Generator(Mod10Check mod10, GeneratorContext context) {
        Mod10Generator generator = new Mod10Generator(context).startIndex(mod10.startIndex()).endIndex(mod10.endIndex()).multiplier(mod10.multiplier()).weight(mod10.weight());
        if (mod10.checkDigitIndex() != -1) {
            generator.checkDigitIndex(mod10.checkDigitIndex());
        }
        return generator;
    }

    private static Mod11Generator getMod11Generator(Mod11Check mod11, GeneratorContext context) {
        Mod11Generator generator = new Mod11Generator(context).startIndex(mod11.startIndex()).endIndex(mod11.endIndex()).threshold(mod11.threshold()).treatCheck10As(mod11.treatCheck10As()).treatCheck11As(mod11.treatCheck11As());
        if (mod11.processingDirection() == Mod11Check.ProcessingDirection.LEFT_TO_RIGHT) {
            generator.leftToRight();
        }
        if (mod11.checkDigitIndex() != -1) {
            generator.checkDigitIndex(mod11.checkDigitIndex());
        }
        return generator;
    }
}

