/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.util;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import org.instancio.exception.InstancioException;
import org.instancio.internal.util.ErrorMessageUtils;
import org.instancio.internal.util.ExceptionUtils;
import org.instancio.internal.util.Fail;
import org.instancio.internal.util.ObjectUtils;
import org.instancio.internal.util.SetterMethodComparator;
import org.instancio.internal.util.Verify;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ReflectionUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ReflectionUtils.class);

    private ReflectionUtils() {
    }

    public static Class<?> loadClass(String fullyQualifiedName) {
        try {
            return Class.forName(fullyQualifiedName);
        }
        catch (Exception ex) {
            LOG.trace("Class not found: '{}'", (Object)fullyQualifiedName);
            return null;
        }
    }

    public static <T extends AccessibleObject> T setAccessible(T object) {
        if (!object.isAccessible()) {
            object.setAccessible(true);
        }
        return object;
    }

    public static <E extends Enum<E>> E[] getEnumValues(Class<E> enumClass) {
        try {
            Method m = ReflectionUtils.setAccessible(enumClass.getDeclaredMethod("values", new Class[0]));
            return (Enum[])m.invoke(null, new Object[0]);
        }
        catch (Exception ex) {
            throw new InstancioException("Error getting enum values for: " + enumClass, ex);
        }
    }

    public static Type getSetMethodParameterType(Method method) {
        Parameter[] p = method.getParameters();
        Verify.isTrue(p.length == 1, "Expected exactly 1 parameter, but got: %s", p.length);
        return ObjectUtils.defaultIfNull(p[0].getParameterizedType(), p[0].getType());
    }

    public static Method getSetterMethod(Class<?> klass, String methodName, Class<?> parameterType) {
        if (parameterType == null) {
            Optional<Method> first = Arrays.stream(klass.getDeclaredMethods()).filter(m -> m.getParameterCount() == 1 && m.getName().equals(methodName)).min(new SetterMethodComparator());
            if (first.isPresent()) {
                return first.get();
            }
        } else {
            try {
                return klass.getDeclaredMethod(methodName, parameterType);
            }
            catch (NoSuchMethodException first) {
                // empty catch block
            }
        }
        String method = parameterType == null ? methodName : String.format("%s(%s)", methodName, parameterType.getSimpleName());
        throw Fail.withUsageError("Could not find method method '%s' declared by %s", method, klass);
    }

    public static Field getField(Class<?> klass, String fieldName) {
        try {
            return klass.getDeclaredField(Verify.notNull(fieldName, "null field name", new Object[0]));
        }
        catch (NoSuchFieldException ex) {
            throw Fail.withUsageError("invalid field '" + fieldName + "' for " + klass, ex);
        }
        catch (SecurityException ex) {
            throw new InstancioException("Unable to access '" + fieldName + "' of " + klass, ex);
        }
    }

    @Nullable
    public static Field getFieldOrNull(Class<?> klass, String fieldName) {
        try {
            return klass.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException ex) {
            return null;
        }
        catch (SecurityException ex) {
            throw new InstancioException("Unable to access '" + fieldName + "' of " + klass, ex);
        }
    }

    public static Object tryGetFieldValueOrElseNull(Field field, Object target) {
        try {
            ReflectionUtils.setAccessible(field);
            return field.get(target);
        }
        catch (Exception ex) {
            String objectType = target == null ? null : target.getClass().getTypeName();
            String msg = String.format("Error getting field value.%n -> Field ........: %s%n -> Declared by ..: %s", field, objectType);
            ExceptionUtils.logException(msg, ex, new Object[0]);
            return null;
        }
    }

    public static Object getFieldValue(Field field, Object target) {
        try {
            ReflectionUtils.setAccessible(field);
            return field.get(target);
        }
        catch (IllegalArgumentException ex) {
            throw Fail.withUsageError(ErrorMessageUtils.unableToGetValueFromField(field, target), ex);
        }
        catch (Exception ex) {
            throw new InstancioException("Unable to get value from: " + field, ex);
        }
    }

    public static boolean hasNonNullValue(Field field, Object object) {
        return ReflectionUtils.getFieldValue(field, object) != null;
    }

    public static boolean hasNonNullOrNonDefaultPrimitiveValue(Field field, Object object) {
        Object fieldValue = ReflectionUtils.getFieldValue(field, object);
        return ReflectionUtils.neitherNullNorPrimitiveWithDefaultValue(field.getType(), fieldValue);
    }

    public static boolean isArrayOrConcrete(Class<?> klass) {
        return klass.isArray() || !klass.isInterface() && !Modifier.isAbstract(klass.getModifiers());
    }

    public static boolean neitherNullNorPrimitiveWithDefaultValue(Class<?> type, @Nullable Object value) {
        return !Objects.equals(ObjectUtils.defaultValue(type), value);
    }

    public static Class<?> getClass(String name) {
        try {
            return Class.forName(name);
        }
        catch (ClassNotFoundException ex) {
            throw Fail.withUsageError("class not found: '%s'", name, ex);
        }
        catch (Exception ex) {
            throw Fail.withUsageError("failed loading class: '%s'", name, ex);
        }
    }

    public static <T> T newInstance(Class<T> klass) {
        try {
            Constructor<T> ctor = klass.getDeclaredConstructor(new Class[0]);
            return ctor.newInstance(new Object[0]);
        }
        catch (Exception ex) {
            throw new InstancioException("Error instantiating " + klass, ex);
        }
    }
}

