/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.selectors;

import java.lang.annotation.Annotation;
import org.instancio.GroupableSelector;
import org.instancio.Scope;
import org.instancio.ScopeableSelector;
import org.instancio.TypeSelectorBuilder;
import org.instancio.internal.ApiValidator;
import org.instancio.internal.selectors.PredicateScopeImpl;
import org.instancio.internal.selectors.PredicateSelectorBuilderTemplate;
import org.instancio.internal.selectors.PredicateSelectorImpl;
import org.instancio.internal.util.ErrorMessageUtils;

public class TypeSelectorBuilderImpl
extends PredicateSelectorBuilderTemplate<Class<?>>
implements TypeSelectorBuilder {
    @Override
    protected String apiMethod() {
        return "types()";
    }

    @Override
    protected PredicateSelectorImpl.Builder createBuilder() {
        return PredicateSelectorImpl.builder().typePredicate(this.buildPredicate());
    }

    @Override
    public TypeSelectorBuilder of(Class<?> type) {
        ApiValidator.notNull(type, () -> ErrorMessageUtils.selectorNotNullErrorMessage("type must not be null.", "of", this.description().toString(), new Throwable()));
        this.addPredicate(type::isAssignableFrom);
        this.description().append(".of(").append(type.getSimpleName()).append(')');
        return this;
    }

    @Override
    public <A extends Annotation> TypeSelectorBuilder annotated(Class<? extends A> annotation) {
        ApiValidator.notNull(annotation, () -> ErrorMessageUtils.selectorNotNullErrorMessage("type's declared annotation must not be null.", "annotated", this.description().toString(), new Throwable()));
        this.addPredicate(klass -> klass.getDeclaredAnnotation(annotation) != null);
        this.description().append(".annotated(").append(annotation.getSimpleName()).append(')');
        return this;
    }

    @Override
    public TypeSelectorBuilder excluding(Class<?> type) {
        ApiValidator.notNull(type, () -> ErrorMessageUtils.selectorNotNullErrorMessage("excluded type must not be null.", "excluding", this.description().toString(), new Throwable()));
        this.addPredicate(klass -> klass != type);
        this.description().append(".excluding(").append(type.getSimpleName()).append(')');
        return this;
    }

    @Override
    public ScopeableSelector lenient() {
        this.setLenient();
        return this;
    }

    @Override
    public GroupableSelector within(Scope ... scopes) {
        this.withScopes(scopes);
        return this;
    }

    @Override
    public Scope toScope() {
        return new PredicateScopeImpl(this.build());
    }
}

