/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.generator.time;

import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.temporal.TemporalUnit;
import org.instancio.Random;
import org.instancio.generator.GeneratorContext;
import org.instancio.generator.specs.OffsetDateTimeGeneratorAsSpec;
import org.instancio.generator.specs.OffsetDateTimeSpec;
import org.instancio.internal.ApiValidator;
import org.instancio.internal.generator.time.JavaTimeTemporalGenerator;
import org.instancio.internal.generator.time.LocalDateTimeGenerator;
import org.instancio.internal.util.Constants;
import org.instancio.support.Global;

public class OffsetDateTimeGenerator
extends JavaTimeTemporalGenerator<OffsetDateTime>
implements OffsetDateTimeSpec,
OffsetDateTimeGeneratorAsSpec {
    private static final ZoneOffset ZONE_OFFSET = Constants.ZONE_OFFSET;
    static final OffsetDateTime DEFAULT_MIN = Constants.DEFAULT_MIN.atOffset(ZONE_OFFSET);
    static final OffsetDateTime DEFAULT_MAX = Constants.DEFAULT_MAX.atOffset(ZONE_OFFSET);
    private final LocalDateTimeGenerator delegate;

    public OffsetDateTimeGenerator() {
        this(Global.generatorContext());
    }

    public OffsetDateTimeGenerator(GeneratorContext context) {
        super(context, DEFAULT_MIN, DEFAULT_MAX);
        this.delegate = new LocalDateTimeGenerator(context);
    }

    @Override
    public String apiMethod() {
        return "offsetDateTime()";
    }

    @Override
    public OffsetDateTimeGenerator past() {
        super.past();
        return this;
    }

    @Override
    public OffsetDateTimeGenerator future() {
        super.future();
        return this;
    }

    @Override
    public OffsetDateTimeGenerator min(OffsetDateTime min) {
        super.min(min);
        return this;
    }

    @Override
    public OffsetDateTimeGenerator max(OffsetDateTime max) {
        super.max(max);
        return this;
    }

    @Override
    public OffsetDateTimeGenerator range(OffsetDateTime min, OffsetDateTime max) {
        super.range(min, max);
        return this;
    }

    @Override
    public OffsetDateTimeGenerator truncatedTo(TemporalUnit unit) {
        super.truncatedTo(unit);
        return this;
    }

    @Override
    public OffsetDateTimeGenerator nullable() {
        super.nullable();
        return this;
    }

    @Override
    OffsetDateTime getLatestPast() {
        return OffsetDateTime.now(ZONE_OFFSET).minusSeconds(1L);
    }

    @Override
    OffsetDateTime getEarliestFuture() {
        return OffsetDateTime.now(ZONE_OFFSET).plusMinutes(1L);
    }

    @Override
    void validateRange() {
        ApiValidator.validateStartEnd((OffsetDateTime)this.min, (OffsetDateTime)this.max);
    }

    @Override
    protected OffsetDateTime tryGenerateNonNull(Random random) {
        this.delegate.range(((OffsetDateTime)this.min).toLocalDateTime(), ((OffsetDateTime)this.max).toLocalDateTime());
        LocalDateTime ldt = this.delegate.tryGenerateNonNull(random);
        OffsetDateTime result = OffsetDateTime.of(ldt, ZONE_OFFSET);
        return this.truncateTo == null ? result : result.truncatedTo(this.truncateTo);
    }
}

