/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.generator.lang;

import org.instancio.Random;
import org.instancio.generator.GeneratorContext;
import org.instancio.generator.specs.FloatSpec;
import org.instancio.internal.generator.lang.AbstractRandomComparableNumberGeneratorSpec;
import org.instancio.settings.Keys;
import org.instancio.support.Global;

public class FloatGenerator
extends AbstractRandomComparableNumberGeneratorSpec<Float>
implements FloatSpec {
    public FloatGenerator() {
        this(Global.generatorContext());
    }

    public FloatGenerator(GeneratorContext context) {
        super(context, context.getSettings().get(Keys.FLOAT_MIN), context.getSettings().get(Keys.FLOAT_MAX), context.getSettings().get(Keys.FLOAT_NULLABLE));
    }

    @Override
    public String apiMethod() {
        return "floats()";
    }

    @Override
    public FloatGenerator min(Float min) {
        super.min(min);
        return this;
    }

    @Override
    public FloatGenerator max(Float max) {
        super.max(max);
        return this;
    }

    @Override
    public FloatGenerator range(Float min, Float max) {
        super.range(min, max);
        return this;
    }

    @Override
    public FloatGenerator nullable() {
        super.nullable();
        return this;
    }

    @Override
    public FloatGenerator nullable(boolean isNullable) {
        super.nullable(isNullable);
        return this;
    }

    @Override
    protected Float tryGenerateNonNull(Random random) {
        return Float.valueOf(random.floatRange(((Float)this.getMin()).floatValue(), ((Float)this.getMax()).floatValue()));
    }
}

