/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.generator.lang;

import org.instancio.generator.GeneratorContext;
import org.instancio.generator.specs.NumberAsGeneratorSpec;
import org.instancio.internal.ApiValidator;
import org.instancio.internal.generator.lang.AbstractRandomNumberGeneratorSpec;
import org.instancio.internal.util.NumberUtils;

public abstract class AbstractRandomComparableNumberGeneratorSpec<T extends Number>
extends AbstractRandomNumberGeneratorSpec<T> {
    protected AbstractRandomComparableNumberGeneratorSpec(GeneratorContext context, T min, T max, boolean nullable) {
        super(context, min, max, nullable);
    }

    @Override
    public NumberAsGeneratorSpec<T> min(T min) {
        super.min((Number)min);
        super.max((Number)NumberUtils.calculateNewMax(this.getMax(), min, 50));
        return this;
    }

    @Override
    public NumberAsGeneratorSpec<T> max(T max) {
        super.max((Number)max);
        super.min((Number)NumberUtils.calculateNewMin(this.getMin(), max, 50));
        return this;
    }

    @Override
    public NumberAsGeneratorSpec<T> range(T min, T max) {
        super.range((Number)min, (Number)max);
        ApiValidator.isTrue(((Comparable)min).compareTo(max) <= 0, "invalid 'range(%s, %s)': lower bound must be less than or equal to upper bound", min, max);
        return this;
    }
}

