/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.context;

import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.instancio.TargetSelector;
import org.instancio.exception.UnusedSelectorException;
import org.instancio.internal.ApiMethodSelector;
import org.instancio.internal.context.SelectorMaps;
import org.instancio.internal.context.SelectorNodeMatchesCollector;
import org.instancio.internal.selectors.UnusedSelectorDescription;
import org.instancio.internal.util.Constants;

final class UnusedSelectorReporter {
    private final int maxDepth;
    private final SelectorNodeMatchesCollector collector;

    UnusedSelectorReporter(int maxDepth, SelectorMaps selectorMaps) {
        this.maxDepth = maxDepth;
        this.collector = new SelectorNodeMatchesCollector(selectorMaps);
    }

    void report() {
        Map<ApiMethodSelector, Set<TargetSelector>> unused = this.collector.getUnusedSelectors();
        if (UnusedSelectorReporter.hasNoUnusedSelectors(unused)) {
            return;
        }
        StringBuilder sb = new StringBuilder(2048).append(Constants.NL).append("Found unused selectors referenced in the following methods:").append(Constants.NL);
        UnusedSelectorReporter.append(unused, sb, ApiMethodSelector.IGNORE);
        UnusedSelectorReporter.append(unused, sb, ApiMethodSelector.WITH_NULLABLE);
        UnusedSelectorReporter.append(unused, sb, ApiMethodSelector.GENERATE);
        UnusedSelectorReporter.append(unused, sb, ApiMethodSelector.ON_COMPLETE);
        UnusedSelectorReporter.append(unused, sb, ApiMethodSelector.SUBTYPE);
        UnusedSelectorReporter.append(unused, sb, ApiMethodSelector.ASSIGN_ORIGIN);
        UnusedSelectorReporter.append(unused, sb, ApiMethodSelector.ASSIGN_DESTINATION);
        UnusedSelectorReporter.append(unused, sb, ApiMethodSelector.SET_MODEL);
        UnusedSelectorReporter.append(unused, sb, ApiMethodSelector.FILTER);
        sb.append(Constants.NL).append("This error aims to highlight potential problems and help maintain clean test code.").append(Constants.NL).append(Constants.NL).append("Possible causes:").append(Constants.NL).append(Constants.NL).append(" -> Selector did not match any field or class within this object.").append(Constants.NL).append(" -> Selector target is beyond the current maximum depth setting: ").append(this.maxDepth).append(Constants.NL).append(" -> Selector matches an ignored target, for example:").append(Constants.NL).append(Constants.NL).append("    Person person = Instancio.of(Person.class)").append(Constants.NL).append("        .ignore(all(Phone.class))").append(Constants.NL).append("        .set(field(Phone::getNumber), \"555-66-77\") // unused!").append(Constants.NL).append("        .create();").append(Constants.NL).append(Constants.NL).append(" -> Selector targets a field or class in an object that was provided by:").append(Constants.NL).append("    -> set(TargetSelector, Object)").append(Constants.NL).append("    -> supply(TargetSelector, Supplier)").append(Constants.NL).append(Constants.NL).append("    // Example").append(Constants.NL).append("    Supplier<Address> addressSupplier = () -> new Address(...);").append(Constants.NL).append("    Person person = Instancio.of(Person.class)").append(Constants.NL).append("        .supply(all(Address.class), () -> addressSupplier)").append(Constants.NL).append("        .set(field(Address::getCity), \"London\") // unused!").append(Constants.NL).append("        .create();").append(Constants.NL).append(Constants.NL).append("    Instancio does not modify instances provided by a Supplier,").append(Constants.NL).append("    therefore, field(Address::getCity) will trigger unused selector error.").append(Constants.NL).append(Constants.NL).append("To resolve this error:").append(Constants.NL).append(Constants.NL).append(" -> Remove the selector(s) causing the error, if applicable.").append(Constants.NL).append(" -> Suppress the error by enabling 'lenient()' mode:").append(Constants.NL).append(Constants.NL).append("    Example example = Instancio.of(Example.class)").append(Constants.NL).append("        .lenient()").append(Constants.NL).append("        .create();").append(Constants.NL).append(Constants.NL).append("    // Or via Settings").append(Constants.NL).append("    Settings settings = Settings.create()").append(Constants.NL).append("        .set(Keys.MODE, Mode.LENIENT);").append(Constants.NL).append(Constants.NL).append("    Example example = Instancio.of(Example.class)").append(Constants.NL).append("        .withSettings(settings)").append(Constants.NL).append("        .create();").append(Constants.NL).append(Constants.NL).append("For more information see: https://www.instancio.org/user-guide/#selector-strictness").append(Constants.NL);
        throw new UnusedSelectorException(sb.toString(), unused);
    }

    private static void append(Map<ApiMethodSelector, Set<TargetSelector>> map, StringBuilder sb, ApiMethodSelector apiMethod) {
        Set<TargetSelector> selectors = map.get((Object)apiMethod);
        if (!selectors.isEmpty()) {
            sb.append(Constants.NL).append(" -> Unused selector in: ").append(apiMethod.getDescription()).append(Constants.NL).append(UnusedSelectorReporter.formatSelectors(selectors)).append(Constants.NL);
        }
    }

    private static boolean hasNoUnusedSelectors(Map<ApiMethodSelector, Set<TargetSelector>> unusedSelectorMap) {
        for (Set<TargetSelector> unusedSelectors : unusedSelectorMap.values()) {
            if (unusedSelectors.isEmpty()) continue;
            return false;
        }
        return true;
    }

    private static String formatSelectors(Set<TargetSelector> selectors) {
        int[] count = new int[]{1};
        return selectors.stream().map(UnusedSelectorDescription.class::cast).map(UnusedSelectorDescription::getDescription).distinct().sorted().map(it -> {
            Object[] objectArray = new Object[2];
            int n = count[0];
            count[0] = n + 1;
            objectArray[0] = n;
            objectArray[1] = it;
            return String.format(" %s: %s", objectArray);
        }).collect(Collectors.joining(Constants.NL));
    }
}

