/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.annotation;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.instancio.internal.util.CollectionUtils;
import org.instancio.internal.util.Verify;
import org.jetbrains.annotations.VisibleForTesting;

public class AnnotationMap {
    private final Map<Class<?>, Annotation> map;
    private Annotation primary;

    public AnnotationMap(Annotation ... annotations) {
        this.map = CollectionUtils.asLinkedHashMap(Annotation::annotationType, annotations);
    }

    <A extends Annotation> A get(Class<?> key) {
        return (A)this.map.get(key);
    }

    Collection<Annotation> getAnnotations() {
        Collection<Annotation> values = this.map.values();
        return values.isEmpty() ? Collections.emptyList() : new ArrayList<Annotation>(values);
    }

    public void setPrimary(Annotation annotation) {
        this.primary = annotation;
        this.map.remove(this.primary.annotationType());
    }

    Annotation removePrimary() {
        Annotation p = this.primary;
        if (this.primary != null) {
            this.primary = null;
        }
        return p;
    }

    void remove(Class<?> key) {
        Annotation removed = this.map.remove(key);
        Verify.isFalse(removed == null, "Annotation map does not contain: %s", key.getName());
    }

    @VisibleForTesting
    Map<Class<?>, Annotation> getMap() {
        return this.map;
    }
}

