/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.context;

import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import org.instancio.Assignment;
import org.instancio.GeneratorSpecProvider;
import org.instancio.OnCompleteCallback;
import org.instancio.Random;
import org.instancio.TargetSelector;
import org.instancio.generator.Generator;
import org.instancio.generator.GeneratorContext;
import org.instancio.internal.ApiValidator;
import org.instancio.internal.Flattener;
import org.instancio.internal.RandomHelper;
import org.instancio.internal.assignment.InternalAssignment;
import org.instancio.internal.context.AssignmentSelectorMap;
import org.instancio.internal.context.BooleanSelectorMap;
import org.instancio.internal.context.GeneratorSelectorMap;
import org.instancio.internal.context.InternalContainerFactoryProviderImpl;
import org.instancio.internal.context.ModelContextHelper;
import org.instancio.internal.context.OnCompleteCallbackSelectorMap;
import org.instancio.internal.context.SelectorMap;
import org.instancio.internal.context.SubtypeSelectorMap;
import org.instancio.internal.context.UnusedEmitItemsReporter;
import org.instancio.internal.context.UnusedSelectorReporter;
import org.instancio.internal.generator.misc.GeneratorDecorator;
import org.instancio.internal.nodes.InternalNode;
import org.instancio.internal.spi.InternalContainerFactoryProvider;
import org.instancio.internal.spi.InternalServiceProviderContext;
import org.instancio.internal.spi.Providers;
import org.instancio.internal.util.CollectionUtils;
import org.instancio.internal.util.ObjectUtils;
import org.instancio.internal.util.ServiceLoaders;
import org.instancio.internal.util.TypeUtils;
import org.instancio.internal.util.Verify;
import org.instancio.settings.Keys;
import org.instancio.settings.Mode;
import org.instancio.settings.Settings;
import org.instancio.spi.InstancioServiceProvider;
import org.instancio.support.Global;
import org.instancio.support.ThreadLocalSettings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ModelContext<T> {
    private static final Logger LOG = LoggerFactory.getLogger(ModelContext.class);
    private static final List<InternalContainerFactoryProvider> CONTAINER_FACTORIES = CollectionUtils.combine(ServiceLoaders.loadAll(InternalContainerFactoryProvider.class), new InternalContainerFactoryProviderImpl());
    private final Providers providers;
    private final Type rootType;
    private final List<Type> rootTypeParameters;
    private final Map<TypeVariable<?>, Type> rootTypeMap;
    private final Integer maxDepth;
    private final Long seed;
    private final Random random;
    private final Settings settings;
    private final BooleanSelectorMap ignoredSelectorMap;
    private final BooleanSelectorMap nullableSelectorMap;
    private final OnCompleteCallbackSelectorMap onCompleteCallbackSelectorMap;
    private final SubtypeSelectorMap subtypeSelectorMap;
    private final GeneratorSelectorMap generatorSelectorMap;
    private final AssignmentSelectorMap assignmentSelectorMap;
    private final boolean verbose;

    private ModelContext(Builder<T> builder) {
        this.rootType = ((Builder)builder).rootType;
        this.rootTypeParameters = Collections.unmodifiableList(((Builder)builder).rootTypeParameters);
        this.rootTypeMap = this.rootType instanceof ParameterizedType || this.rootType instanceof GenericArrayType ? Collections.emptyMap() : Collections.unmodifiableMap(ModelContextHelper.buildRootTypeMap(((Builder)builder).rootType, ((Builder)builder).rootTypeParameters));
        this.seed = ((Builder)builder).seed;
        this.maxDepth = ((Builder)builder).maxDepth;
        this.settings = ModelContext.createSettings(builder);
        this.random = RandomHelper.resolveRandom(this.settings.get(Keys.SEED), ((Builder)builder).seed);
        this.verbose = ((Builder)builder).verbose;
        this.ignoredSelectorMap = new BooleanSelectorMap(((Builder)builder).ignoredTargets);
        this.nullableSelectorMap = new BooleanSelectorMap(((Builder)builder).nullableTargets);
        this.onCompleteCallbackSelectorMap = new OnCompleteCallbackSelectorMap(((Builder)builder).onCompleteCallbacks);
        GeneratorContext generatorContext = new GeneratorContext(this.settings, this.random);
        this.generatorSelectorMap = new GeneratorSelectorMap(generatorContext, ((Builder)builder).generatorSelectors, ((Builder)builder).generatorSpecSelectors);
        this.assignmentSelectorMap = new AssignmentSelectorMap(((Builder)builder).assignmentSelectors, generatorContext);
        this.subtypeSelectorMap = new SubtypeSelectorMap(((Builder)builder).subtypeSelectors, this.generatorSelectorMap.getGeneratorSubtypeMap(), this.assignmentSelectorMap.getGeneratorSubtypeMap());
        this.providers = new Providers(ServiceLoaders.loadAll(InstancioServiceProvider.class), new InternalServiceProviderContext(this.settings, this.random));
    }

    private static Settings createSettings(Builder<?> builder) {
        Settings settings = Global.getPropertiesFileSettings().merge(ThreadLocalSettings.getInstance().get()).merge(((Builder)builder).settings);
        if (Boolean.TRUE.equals(((Builder)builder).lenient)) {
            settings.set(Keys.MODE, Mode.LENIENT);
        }
        LOG.trace("Resolved settings: {}", (Object)settings);
        return settings.lock();
    }

    public List<InternalContainerFactoryProvider> getContainerFactories() {
        return CONTAINER_FACTORIES;
    }

    public Providers getServiceProviders() {
        return this.providers;
    }

    public void reportWarnings() {
        this.reportUnusedSelectorWarnings();
        this.reportEmitGeneratorWarnings();
    }

    private void reportEmitGeneratorWarnings() {
        SelectorMap<Generator<?>> selectorMap = this.generatorSelectorMap.getSelectorMap();
        UnusedEmitItemsReporter reporter = new UnusedEmitItemsReporter(selectorMap);
        reporter.report();
    }

    void reportUnusedSelectorWarnings() {
        if (this.settings.get(Keys.MODE) == Mode.STRICT) {
            UnusedSelectorReporter reporter = UnusedSelectorReporter.builder().maxDepth(this.getMaxDepth()).ignored(this.ignoredSelectorMap.getSelectorMap().getUnusedKeys()).nullable(this.nullableSelectorMap.getSelectorMap().getUnusedKeys()).generators(this.generatorSelectorMap.getSelectorMap().getUnusedKeys()).callbacks(this.onCompleteCallbackSelectorMap.getSelectorMap().getUnusedKeys()).subtypes(this.subtypeSelectorMap.getSelectorMap().getUnusedKeys()).assignmentOrigins(this.assignmentSelectorMap.getDestinationSelectors().getSelectorMap().getUnusedKeys()).assignmentDestinations(this.assignmentSelectorMap.getSelectorMap().getUnusedKeys()).build();
            reporter.report();
        }
    }

    public Type getRootType() {
        return this.rootType;
    }

    public Integer getMaxDepth() {
        return ObjectUtils.defaultIfNull(this.maxDepth, this.settings.get(Keys.MAX_DEPTH));
    }

    public boolean isIgnored(InternalNode node) {
        return this.ignoredSelectorMap.isTrue(node);
    }

    public boolean isNullable(InternalNode node) {
        return this.nullableSelectorMap.isTrue(node);
    }

    public Optional<Generator<?>> getGenerator(InternalNode node) {
        return this.generatorSelectorMap.getGenerator(node);
    }

    public List<OnCompleteCallback<?>> getCallbacks(InternalNode node) {
        return this.onCompleteCallbackSelectorMap.getCallbacks(node);
    }

    public BooleanSelectorMap getIgnoredSelectorMap() {
        return this.ignoredSelectorMap;
    }

    public SubtypeSelectorMap getSubtypeSelectorMap() {
        return this.subtypeSelectorMap;
    }

    public Map<TypeVariable<?>, Type> getRootTypeMap() {
        return this.rootTypeMap;
    }

    public Settings getSettings() {
        return this.settings;
    }

    public Random getRandom() {
        return this.random;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public Builder<T> toBuilder() {
        Builder builder = new Builder(this.rootType);
        builder.rootTypeParameters.addAll(this.rootTypeParameters);
        builder.maxDepth = this.maxDepth;
        builder.seed = this.seed;
        builder.settings = this.settings;
        builder.nullableTargets.addAll(this.nullableSelectorMap.getTargetSelectors());
        builder.ignoredTargets.addAll(this.ignoredSelectorMap.getTargetSelectors());
        builder.generatorSelectors.putAll(this.generatorSelectorMap.getGeneratorSelectors());
        builder.generatorSpecSelectors.putAll(this.generatorSelectorMap.getGeneratorSpecSelectors());
        builder.subtypeSelectors.putAll(this.subtypeSelectorMap.getSubtypeSelectors());
        builder.onCompleteCallbacks.putAll(this.onCompleteCallbackSelectorMap.getOnCompleteCallbackSelectors());
        builder.assignmentSelectors.putAll(this.assignmentSelectorMap.getAssignmentSelectors());
        return builder;
    }

    public static <T> Builder<T> builder(Type rootType) {
        return new Builder(rootType);
    }

    public List<InternalAssignment> getAssignments(InternalNode node) {
        return this.assignmentSelectorMap.getAssignments(node);
    }

    public BooleanSelectorMap getAssignmentOriginSelectorMap() {
        return this.assignmentSelectorMap.getOriginSelectors();
    }

    public List<TargetSelector> getAssignmentDestinationSelectors(InternalNode node) {
        return this.assignmentSelectorMap.getDestinationSelectors(node);
    }

    public static final class Builder<T> {
        private final Type rootType;
        private final Class<T> rootClass;
        private final List<Type> rootTypeParameters = new ArrayList<Type>();
        private final Map<TargetSelector, Class<?>> subtypeSelectors = new LinkedHashMap();
        private final Map<TargetSelector, GeneratorSpecProvider<?>> generatorSpecSelectors = new LinkedHashMap();
        private final Map<TargetSelector, Generator<?>> generatorSelectors = new LinkedHashMap();
        private final Map<TargetSelector, OnCompleteCallback<?>> onCompleteCallbacks = new LinkedHashMap();
        private final Map<TargetSelector, List<Assignment>> assignmentSelectors = new LinkedHashMap<TargetSelector, List<Assignment>>();
        private final Set<TargetSelector> ignoredTargets = new LinkedHashSet<TargetSelector>();
        private final Set<TargetSelector> nullableTargets = new LinkedHashSet<TargetSelector>();
        private Settings settings;
        private Integer maxDepth;
        private Long seed;
        private Boolean lenient;
        private boolean verbose;

        private Builder(Type rootType) {
            this.rootType = Verify.notNull(rootType, "Root type is null", new Object[0]);
            this.rootClass = TypeUtils.getRawType(this.rootType);
        }

        public Builder<T> withRootTypeParameters(List<Type> rootTypeParameters) {
            ApiValidator.validateTypeParameters(this.rootClass, rootTypeParameters);
            this.rootTypeParameters.addAll(rootTypeParameters);
            return this;
        }

        public Builder<T> withSubtype(TargetSelector selector, Class<?> subtype) {
            this.subtypeSelectors.put(ModelContextHelper.preProcess(selector, this.rootClass), ApiValidator.notNull(subtype, "subtype must not be null", new Object[0]));
            return this;
        }

        public Builder<T> withGenerator(TargetSelector selector, Generator<?> generator) {
            this.generatorSelectors.put(ModelContextHelper.preProcess(selector, this.rootClass), generator);
            return this;
        }

        public Builder<T> withSupplier(TargetSelector selector, Supplier<?> supplier) {
            return this.withGenerator(selector, GeneratorDecorator.decorate(supplier));
        }

        public <V> Builder<T> withGeneratorSpec(TargetSelector selector, GeneratorSpecProvider<V> spec) {
            this.generatorSpecSelectors.put(ModelContextHelper.preProcess(selector, this.rootClass), spec);
            return this;
        }

        public Builder<T> withOnCompleteCallback(TargetSelector selector, OnCompleteCallback<?> callback) {
            this.onCompleteCallbacks.put(ModelContextHelper.preProcess(selector, this.rootClass), callback);
            return this;
        }

        public Builder<T> withIgnored(TargetSelector selector) {
            this.ignoredTargets.add(ModelContextHelper.preProcess(selector, this.rootClass));
            return this;
        }

        public Builder<T> withNullable(TargetSelector selector) {
            this.nullableTargets.add(ModelContextHelper.preProcess(selector, this.rootClass));
            return this;
        }

        public Builder<T> withMaxDepth(int maxDepth) {
            this.maxDepth = maxDepth;
            return this;
        }

        public Builder<T> withAssignments(Assignment ... assignments) {
            for (Assignment assignment : assignments) {
                ApiValidator.notNull(assignment, "assignments array must not contain null", new Object[0]);
                this.processAssignment(assignment);
            }
            return this;
        }

        private void processAssignment(Assignment assignment) {
            List assignments = ((Flattener)((Object)assignment)).flatten();
            for (InternalAssignment a : assignments) {
                TargetSelector origin = ModelContextHelper.preProcess(a.getOrigin(), this.rootClass);
                TargetSelector destination = ModelContextHelper.preProcess(a.getDestination(), this.rootClass);
                InternalAssignment processedAssignment = a.toBuilder().origin(origin).destination(destination).build();
                this.assignmentSelectors.computeIfAbsent(destination, k -> new ArrayList()).add(processedAssignment);
            }
        }

        public Builder<T> withSettings(Settings arg) {
            ApiValidator.notNull(arg, "Null Settings provided to withSettings() method", new Object[0]);
            this.settings = this.settings == null ? Settings.from(arg) : this.settings.merge(arg);
            return this;
        }

        public Builder<T> withSeed(long seed) {
            this.seed = seed;
            return this;
        }

        public Builder<T> lenient() {
            this.lenient = true;
            return this;
        }

        public Builder<T> verbose() {
            this.verbose = true;
            return this;
        }

        public Builder<T> useModelAsTypeArgument(ModelContext<?> otherContext) {
            this.rootTypeParameters.add(otherContext.getRootType());
            this.seed = ((ModelContext)otherContext).seed;
            this.nullableTargets.addAll(((ModelContext)otherContext).nullableSelectorMap.getTargetSelectors());
            this.ignoredTargets.addAll(((ModelContext)otherContext).ignoredSelectorMap.getTargetSelectors());
            this.generatorSelectors.putAll(((ModelContext)otherContext).generatorSelectorMap.getGeneratorSelectors());
            this.generatorSpecSelectors.putAll(((ModelContext)otherContext).generatorSelectorMap.getGeneratorSpecSelectors());
            this.subtypeSelectors.putAll(((ModelContext)otherContext).subtypeSelectorMap.getSubtypeSelectors());
            this.onCompleteCallbacks.putAll(((ModelContext)otherContext).onCompleteCallbackSelectorMap.getOnCompleteCallbackSelectors());
            this.assignmentSelectors.putAll(((ModelContext)otherContext).assignmentSelectorMap.getAssignmentSelectors());
            this.maxDepth = ((ModelContext)otherContext).maxDepth == null ? null : Integer.valueOf(((ModelContext)otherContext).maxDepth + 1);
            this.settings = Settings.from(((ModelContext)otherContext).settings).set(Keys.MAX_DEPTH, ((ModelContext)otherContext).settings.get(Keys.MAX_DEPTH) + 1).lock();
            return this;
        }

        public ModelContext<T> build() {
            return new ModelContext(this);
        }
    }
}

