/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal;

import java.util.ArrayDeque;
import org.instancio.internal.GenerationListener;
import org.instancio.internal.context.ModelContext;
import org.instancio.internal.generator.GeneratorResult;
import org.instancio.internal.nodes.InternalNode;
import org.instancio.settings.Keys;
import org.instancio.settings.Mode;

class GeneratedNullValueListener
implements GenerationListener {
    private final ModelContext<?> context;
    private final boolean isLenientMode;

    GeneratedNullValueListener(ModelContext<?> context) {
        this.context = context;
        this.isLenientMode = context.getSettings().get(Keys.MODE) == Mode.LENIENT;
    }

    @Override
    public void objectCreated(InternalNode node, GeneratorResult result) {
        if (this.isLenientMode || !result.containsNull()) {
            return;
        }
        ArrayDeque<InternalNode> queue = new ArrayDeque<InternalNode>();
        queue.add(node);
        while (!queue.isEmpty()) {
            InternalNode current = (InternalNode)queue.poll();
            if (result.isIgnored()) {
                this.context.isIgnored(current);
                continue;
            }
            if (!result.containsNull()) continue;
            this.context.isIgnored(current);
            this.context.isNullable(current);
            this.context.getGenerator(current);
            this.context.getCallbacks(current);
            this.context.getSubtypeSelectorMap().getSubtype(current);
            this.context.getAssignments(current);
            this.context.getAssignmentDestinationSelectors(current);
            queue.addAll(current.getChildren());
        }
    }
}

