/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.util;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Objects;
import org.instancio.exception.InstancioApiException;
import org.instancio.exception.InstancioException;
import org.instancio.internal.util.ExceptionHandler;
import org.instancio.internal.util.Fail;
import org.instancio.internal.util.ObjectUtils;
import org.instancio.internal.util.Verify;
import org.jetbrains.annotations.Nullable;

public final class ReflectionUtils {
    private ReflectionUtils() {
    }

    public static Class<?> loadClass(String fullyQualifiedName) {
        try {
            return Class.forName(fullyQualifiedName);
        }
        catch (Exception ex) {
            ExceptionHandler.logException("Could not load class: '{}'", ex, fullyQualifiedName);
            return null;
        }
    }

    public static <E extends Enum<E>> E[] getEnumValues(Class<E> enumClass) {
        try {
            Method m = enumClass.getDeclaredMethod("values", new Class[0]);
            m.setAccessible(true);
            return (Enum[])m.invoke(null, new Object[0]);
        }
        catch (Exception ex) {
            throw new InstancioException("Error getting enum values for class: " + enumClass.getName(), ex);
        }
    }

    public static boolean isValidField(Class<?> klass, String fieldName) {
        try {
            klass.getDeclaredField(fieldName);
            return true;
        }
        catch (NoSuchFieldException ex) {
            return false;
        }
    }

    public static Field getField(Class<?> klass, String fieldName) {
        try {
            return klass.getDeclaredField(Verify.notNull(fieldName, "null field name", new Object[0]));
        }
        catch (NoSuchFieldException ex) {
            throw Fail.withUsageError("invalid field '" + fieldName + "' for " + klass, ex);
        }
        catch (SecurityException ex) {
            throw new InstancioException("Unable to access '" + fieldName + "' of " + klass, ex);
        }
    }

    public static Object getFieldValue(Field field, Object target) {
        try {
            field.setAccessible(true);
            return field.get(target);
        }
        catch (Exception ex) {
            throw new InstancioException("Unable to get value from: " + field, ex);
        }
    }

    public static boolean hasNonNullValue(Field field, Object object) {
        return ReflectionUtils.getFieldValue(field, object) != null;
    }

    public static boolean hasNonNullOrNonDefaultPrimitiveValue(Field field, Object object) {
        Object fieldValue = ReflectionUtils.getFieldValue(field, object);
        return ReflectionUtils.neitherNullNorPrimitiveWithDefaultValue(field.getType(), fieldValue);
    }

    public static boolean isArrayOrConcrete(Class<?> klass) {
        return klass.isArray() || !klass.isInterface() && !Modifier.isAbstract(klass.getModifiers());
    }

    public static boolean neitherNullNorPrimitiveWithDefaultValue(Class<?> type, @Nullable Object value) {
        return !Objects.equals(ObjectUtils.defaultValue(type), value);
    }

    public static Class<?> getClass(String name) {
        try {
            return Class.forName(name);
        }
        catch (ClassNotFoundException ex) {
            throw new InstancioApiException(String.format("Class not found: '%s'", name), ex);
        }
        catch (Exception ex) {
            throw new InstancioApiException(String.format("Unable to get class: '%s'", name), ex);
        }
    }
}

