/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.util;

import java.util.stream.IntStream;
import org.instancio.internal.util.NumberUtils;
import org.instancio.internal.util.Verify;

public final class LuhnUtils {
    private LuhnUtils() {
    }

    public static boolean isLuhnValid(String s) {
        return LuhnUtils.isLuhnValid(0, s.length() - 1, s.length() - 1, s);
    }

    public static boolean isLuhnValid(int startIdx, int endIdx, int checkIdx, String s) {
        Verify.isTrue(checkIdx >= 0 && (checkIdx < startIdx || checkIdx >= endIdx), "Invalid check digit index %s for range (%s, %s)", checkIdx, startIdx, endIdx);
        int actualEnd = endIdx == checkIdx ? endIdx - 1 : endIdx;
        String payload = s.substring(startIdx, actualEnd + 1);
        return LuhnUtils.getCheckDigit(payload) == s.charAt(checkIdx) - 48;
    }

    public static int getCheckDigit(String payload) {
        return (10 - LuhnUtils.module10(payload)) % 10;
    }

    private static int module10(String payload) {
        String reverse = new StringBuilder(payload).reverse().toString();
        int sum = IntStream.range(0, payload.length()).map(i -> LuhnUtils.extractDigit(i, reverse)).map(NumberUtils::sumDigits).map(NumberUtils::sumDigits).sum();
        return sum % 10;
    }

    private static int extractDigit(int position, String string) {
        int digit = string.charAt(position) - 48;
        return position % 2 == 0 ? digit << 1 : digit;
    }
}

